/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl;

import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.databene.commons.ArrayUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.IOUtil;
import org.databene.commons.ObjectNotFoundException;
import org.databene.commons.StringUtil;
import org.databene.commons.TimeUtil;
import org.databene.commons.converter.TimestampFormatter;
import org.databene.jdbacl.ColumnInfo;
import org.databene.jdbacl.DBUtil;
import org.databene.jdbacl.model.DBCatalog;
import org.databene.jdbacl.model.DBPackage;
import org.databene.jdbacl.model.DBSchema;
import org.databene.jdbacl.model.DBSequence;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.DBTrigger;
import org.databene.jdbacl.sql.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseDialect {
    private static final String DEFAULT_TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss.SSSSSSSSS";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String system;
    public final boolean quoteTableNames;
    protected final boolean sequenceSupported;
    private final DateFormat dateFormat;
    private final DateFormat datetimeFormat;
    private final DateFormat timeFormat;
    private Set<String> reservedWords;

    public DatabaseDialect(String system, boolean quoteTableNames, boolean sequenceSupported, String datePattern, String timePattern, String datetimePattern) {
        this.system = system;
        this.quoteTableNames = quoteTableNames;
        this.sequenceSupported = sequenceSupported;
        this.dateFormat = new SimpleDateFormat(datePattern);
        this.timeFormat = new SimpleDateFormat(timePattern);
        this.datetimeFormat = new SimpleDateFormat(datetimePattern);
        this.reservedWords = null;
    }

    public String getSystem() {
        return this.system;
    }

    public boolean isReservedWord(String word, Connection connection) throws SQLException {
        return word != null && this.getReservedWords(connection).contains(word.toUpperCase());
    }

    public Set<String> getReservedWords(Connection connection) throws SQLException {
        if (this.reservedWords == null) {
            this.importReservedWords(connection);
        }
        return this.reservedWords;
    }

    protected void importReservedWords(Connection connection) throws SQLException {
        this.reservedWords = new HashSet<String>();
        this.parseReservedWordsConfigFile();
        if (connection != null) {
            this.importReservedWordsFromDriver(connection);
        }
    }

    private void importReservedWordsFromDriver(Connection connection) throws SQLException {
        String[] keywords;
        DatabaseMetaData metaData = connection.getMetaData();
        String keywordList = metaData.getSQLKeywords();
        this.logger.debug("Imported keywords: " + keywordList);
        for (String keyword : keywords = StringUtil.splitAndTrim((String)keywordList, (char)',')) {
            this.reservedWords.add(keyword.toUpperCase());
        }
    }

    private void parseReservedWordsConfigFile() {
        String resourceName = "org/databene/jdbacl/dialect/" + this.system + "-reserved_words.txt";
        if (IOUtil.isURIAvailable((String)resourceName)) {
            this.parseReservedWords(resourceName);
        } else {
            this.logger.debug("Configuration file not found: " + resourceName + ". Falling back to SQL:2003 keywords");
            this.parseReservedWords("org/databene/jdbacl/dialect/SQL2003-reserved_words.txt");
        }
    }

    private void parseReservedWords(String resourceName) {
        this.logger.debug("reading reserved word from config file " + resourceName);
        try {
            for (String word : IOUtil.readTextLines((String)resourceName, (boolean)false)) {
                this.reservedWords.add(word.trim());
            }
        }
        catch (IOException e) {
            throw new ConfigurationError("Error reading file " + resourceName, (Throwable)e);
        }
    }

    public abstract boolean isDefaultCatalog(String var1, String var2);

    public abstract boolean isDefaultSchema(String var1, String var2);

    public boolean isSequenceSupported() {
        return this.sequenceSupported;
    }

    public boolean isSequenceBoundarySupported() {
        return this.sequenceSupported;
    }

    public DBSequence[] querySequences(Connection connection) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support querying sequences");
    }

    public void createSequence(String name, long initialValue, Connection connection) throws SQLException {
        if (!this.sequenceSupported) {
            throw this.checkSequenceSupport("createSequence");
        }
        DBUtil.executeUpdate("create sequence " + name + " start with " + initialValue, connection);
    }

    public String renderCreateSequence(DBSequence sequence) {
        Boolean cycle;
        BigInteger increment;
        StringBuilder builder = new StringBuilder("CREATE SEQUENCE ");
        builder.append(this.renderSequenceNameAndType(sequence));
        BigInteger start = sequence.getStart();
        if (start != null && DatabaseDialect.isNotOne(start)) {
            builder.append(" START WITH ").append(start);
        }
        if ((increment = sequence.getIncrement()) != null && DatabaseDialect.isNotOne(increment)) {
            builder.append(" INCREMENT BY ").append(increment);
        }
        if (this.isSequenceBoundarySupported()) {
            BigInteger minValue;
            BigInteger maxValue = sequence.getMaxValue();
            if (maxValue != null) {
                builder.append(" MAXVALUE ").append(maxValue);
            }
            if ((minValue = sequence.getMinValue()) != null) {
                builder.append(" MINVALUE ").append(minValue);
            }
        }
        if ((cycle = sequence.isCycle()) != null) {
            builder.append(cycle != false ? " CYCLE" : " " + this.sequenceNoCycle());
        }
        return builder.toString();
    }

    protected String renderSequenceNameAndType(DBSequence sequence) {
        return sequence.getName();
    }

    protected String sequenceNoCycle() {
        return "NOCYCLE";
    }

    protected static boolean isNotOne(BigInteger i) {
        return BigInteger.ONE.compareTo(i) != 0;
    }

    public String renderFetchSequenceValue(String sequenceName) {
        throw this.checkSequenceSupport("nextSequenceValue");
    }

    public void setNextSequenceValue(String sequenceName, long value, Connection connection) throws SQLException {
        if (this.sequenceSupported) {
            long old = DBUtil.queryLong(this.renderFetchSequenceValue(sequenceName), connection);
            long increment = value - old - 1L;
            if (increment != 0L) {
                BigInteger formerIncrement = this.getSequence(sequenceName, connection).getIncrement();
                DBUtil.executeUpdate("alter sequence " + sequenceName + " increment by " + increment, connection);
                DBUtil.queryLong(this.renderFetchSequenceValue(sequenceName), connection);
                DBUtil.executeUpdate("alter sequence " + sequenceName + " increment by " + formerIncrement, connection);
            }
        } else {
            throw this.checkSequenceSupport("incrementSequence");
        }
    }

    public DBSequence getSequence(String sequenceName, Connection connection) throws SQLException {
        DBSequence[] sequences;
        for (DBSequence seq : sequences = this.querySequences(connection)) {
            if (!seq.getName().equalsIgnoreCase(sequenceName)) continue;
            return seq;
        }
        throw new ObjectNotFoundException("No sequence found with name '" + sequenceName + "'");
    }

    public String renderDropSequence(String sequenceName) {
        if (this.sequenceSupported) {
            return "drop sequence " + sequenceName;
        }
        throw this.checkSequenceSupport("dropSequence");
    }

    public String insert(DBTable table, List<ColumnInfo> columnInfos) {
        int i;
        StringBuilder builder = new StringBuilder("insert into ");
        this.appendQualifiedTableName(table, builder).append(" (");
        if (columnInfos.size() > 0) {
            this.appendColumnName(columnInfos.get((int)0).name, builder);
        }
        for (i = 1; i < columnInfos.size(); ++i) {
            builder.append(",");
            this.appendColumnName(columnInfos.get((int)i).name, builder);
        }
        builder.append(") values (");
        if (columnInfos.size() > 0) {
            builder.append("?");
        }
        for (i = 1; i < columnInfos.size(); ++i) {
            builder.append(",?");
        }
        builder.append(")");
        String sql = builder.toString();
        this.logger.debug("built SQL statement: " + sql);
        return sql;
    }

    public String update(DBTable table, String[] pkColumnNames, List<ColumnInfo> columnInfos) {
        int i;
        if (pkColumnNames.length == 0) {
            throw new UnsupportedOperationException("Cannot update table without primary key: " + table.getName());
        }
        StringBuilder builder = new StringBuilder("update ");
        this.appendQualifiedTableName(table, builder).append(" set");
        for (i = 0; i < columnInfos.size(); ++i) {
            if (ArrayUtil.contains((Object)columnInfos.get((int)i).name, (Object)pkColumnNames)) continue;
            builder.append(" ");
            this.appendColumnName(columnInfos.get((int)i).name, builder);
            builder.append("=?");
            if (i >= columnInfos.size() - pkColumnNames.length - 1) continue;
            builder.append(", ");
        }
        builder.append(" where");
        for (i = 0; i < pkColumnNames.length; ++i) {
            builder.append(' ');
            this.appendColumnName(pkColumnNames[i], builder);
            builder.append("=?");
            if (i >= pkColumnNames.length - 1) continue;
            builder.append(" and");
        }
        String sql = builder.toString();
        this.logger.debug("built SQL statement: " + sql);
        return sql;
    }

    public String formatValue(Object value) {
        if (value instanceof CharSequence || value instanceof Character) {
            return "'" + DBUtil.escape(value.toString()) + "'";
        }
        if (value instanceof Timestamp) {
            return this.formatTimestamp((Timestamp)value);
        }
        if (value instanceof Time) {
            return this.timeFormat.format(value);
        }
        if (value instanceof Date) {
            if (TimeUtil.isMidnight((Date)((Date)value))) {
                return this.dateFormat.format(value);
            }
            return this.datetimeFormat.format(value);
        }
        return String.valueOf(value);
    }

    public String formatTimestamp(Timestamp timestamp) {
        return "'" + new TimestampFormatter(DEFAULT_TIMESTAMP_PATTERN).format(timestamp) + "'";
    }

    private StringBuilder appendQualifiedTableName(DBTable table, StringBuilder builder) {
        DBCatalog catalog = table.getCatalog();
        if (catalog != null && catalog.getName() != null) {
            this.appendQuoted(catalog.getName(), builder).append('.');
        }
        if (table.getSchema() != null && table.getSchema().getName() != null) {
            this.appendQuoted(table.getSchema().getName(), builder).append('.');
        }
        return this.appendQuoted(table.getName(), builder);
    }

    private StringBuilder appendColumnName(String columnName, StringBuilder builder) {
        return this.appendQuoted(columnName, builder);
    }

    private StringBuilder appendQuoted(String name, StringBuilder builder) {
        if (this.quoteTableNames) {
            return builder.append('\"').append(name).append('\"');
        }
        return builder.append(name);
    }

    protected UnsupportedOperationException checkSequenceSupport(String methodName) {
        if (!this.sequenceSupported) {
            return new UnsupportedOperationException("Sequence not supported in " + this.system);
        }
        return new UnsupportedOperationException(methodName + "() not implemented");
    }

    public abstract boolean isDeterministicPKName(String var1);

    public abstract boolean isDeterministicUKName(String var1);

    public abstract boolean isDeterministicFKName(String var1);

    public abstract boolean isDeterministicIndexName(String var1);

    public boolean supportsRegex() {
        return false;
    }

    public String regexQuery(String expression, boolean not, String regex) {
        throw new UnsupportedOperationException(this.system + " does not support regular expressions");
    }

    public String trim(String expression) {
        throw new UnsupportedOperationException(this.system + " does not support trimming");
    }

    public String renderCase(String columnName, String elseExpression, String ... whenThenExpressionPairs) {
        StringBuilder builder = new StringBuilder();
        builder.append("CASE");
        for (int i = 0; i < whenThenExpressionPairs.length; i += 2) {
            builder.append(" WHEN ").append(whenThenExpressionPairs[i]);
            builder.append(" THEN ").append(whenThenExpressionPairs[i + 1]);
        }
        if (!StringUtil.isEmpty((CharSequence)elseExpression)) {
            builder.append(" ELSE ").append(elseExpression);
        }
        builder.append(" END");
        if (columnName != null) {
            builder.append(" AS ").append(columnName);
        }
        return builder.toString();
    }

    public List<DBTrigger> queryTriggers(DBSchema schema, Connection connection) throws SQLException {
        return new ArrayList<DBTrigger>();
    }

    public List<DBPackage> queryPackages(DBSchema schema, Connection connection) throws SQLException {
        return new ArrayList<DBPackage>();
    }

    public abstract void restrictRownums(int var1, int var2, Query var3);
}

