/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl;

import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.ConfigurationError;
import org.databene.commons.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCDriverInfo
implements Serializable {
    private static final long serialVersionUID = 190436633421519236L;
    private static final String DB_DEFINITION_FILE = "org/databene/jdbacl/jdbc-driver-info.xml";
    private String id;
    private String name;
    private String dbSystem;
    private String downloadUrl;
    private String driverClass;
    private String defaultDatabase;
    private String defaultSchema;
    private String defaultPort;
    private String urlPattern;
    private String defaultUser;
    private String[] jars;
    private static HashMap<String, JDBCDriverInfo> instances = new HashMap();
    public static final JDBCDriverInfo HSQL;
    public static final JDBCDriverInfo FIREBIRD;
    public static final JDBCDriverInfo ORACLE;

    public JDBCDriverInfo() {
        this(null, null, null);
    }

    public JDBCDriverInfo(String id, String name, String dbSystem) {
        this.id = id;
        this.name = name;
        this.dbSystem = dbSystem;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = this.normalizeNull(id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = this.normalizeNull(name);
    }

    public String getDbSystem() {
        return this.dbSystem;
    }

    public void setDbSystem(String dbSystem) {
        this.dbSystem = this.normalizeNull(dbSystem);
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = this.normalizeNotNull(urlPattern);
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = this.normalizeNull(downloadUrl);
    }

    public String getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(String defaultPort) {
        this.defaultPort = this.normalizeNull(defaultPort);
    }

    public String[] getJars() {
        return this.jars;
    }

    public void setJars(String[] jars) {
        this.jars = jars;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = this.normalizeNull(driverClass);
    }

    public String getDefaultUser() {
        return this.defaultUser;
    }

    public void setDefaultUser(String defaultUser) {
        this.defaultUser = this.normalizeNull(defaultUser);
    }

    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    public void setDefaultDatabase(String defaultDatabase) {
        this.defaultDatabase = this.normalizeNull(defaultDatabase);
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public String getUrlPrefix() {
        int check = this.urlPattern.indexOf(123);
        return check > 0 ? this.urlPattern.substring(0, check) : this.urlPattern;
    }

    public String jdbcURL(String host, String port, String database) {
        return MessageFormat.format(this.urlPattern, host, port, database);
    }

    private String normalizeNull(String value) {
        return value == null || value.trim().length() == 0 ? null : value.trim();
    }

    private String normalizeNotNull(String value) {
        return value == null || value.trim().length() == 0 ? "" : value.trim();
    }

    public String toString() {
        return this.dbSystem;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JDBCDriverInfo that = (JDBCDriverInfo)obj;
        return this.id.equals(that.id);
    }

    public static Collection<JDBCDriverInfo> getInstances() {
        return instances.values();
    }

    public static JDBCDriverInfo getInstance(String name) {
        return instances.get(name);
    }

    static {
        try {
            Element[] driverElements;
            Document document = XMLUtil.parse((String)DB_DEFINITION_FILE);
            Element root = document.getDocumentElement();
            for (Element driverElement : driverElements = XMLUtil.getChildElements((Element)root)) {
                JDBCDriverInfo driver = new JDBCDriverInfo();
                driver.setId(driverElement.getAttribute("id"));
                driver.setName(driverElement.getAttribute("name"));
                driver.setDbSystem(driverElement.getAttribute("system"));
                driver.setDriverClass(driverElement.getAttribute("class"));
                driver.setDefaultPort(driverElement.getAttribute("port"));
                driver.setDefaultDatabase(driverElement.getAttribute("defaultDatabase"));
                driver.setDefaultSchema(driverElement.getAttribute("defaultSchema"));
                driver.setUrlPattern(driverElement.getAttribute("url"));
                driver.setDownloadUrl(driverElement.getAttribute("info"));
                driver.setDefaultUser(driverElement.getAttribute("user"));
                ArrayBuilder builder = new ArrayBuilder(String.class);
                for (Element dependencyElement : XMLUtil.getChildElements((Element)driverElement, (boolean)false, (String)"dependency")) {
                    builder.add((Object)dependencyElement.getAttribute("lib"));
                }
                driver.setJars((String[])builder.toArray());
                instances.put(driver.getId(), driver);
            }
        }
        catch (IOException e) {
            throw new ConfigurationError("Unable to read database info file", (Throwable)e);
        }
        HSQL = JDBCDriverInfo.getInstance("HSQL");
        FIREBIRD = JDBCDriverInfo.getInstance("FIREBIRD");
        ORACLE = JDBCDriverInfo.getInstance("ORACLE");
    }
}

