/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ConversionException;
import org.databene.commons.converter.UnsafeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetConverter<E>
extends UnsafeConverter<ResultSet, E> {
    private Class<E> targetType;
    private boolean simplifying;
    private static final Logger logger = LoggerFactory.getLogger(ResultSetConverter.class);

    public ResultSetConverter(Class<E> targetType) {
        this(targetType, true);
    }

    public ResultSetConverter(Class<E> targetType, boolean simplifying) {
        super(ResultSet.class, targetType);
        this.targetType = targetType;
        this.simplifying = simplifying;
    }

    public E convert(ResultSet resultSet) throws ConversionException {
        Object[] tmp = ResultSetConverter.convertToArray(resultSet);
        if (this.targetType.isArray()) {
            return (E)tmp;
        }
        return (E)(!this.simplifying || tmp.length > 1 ? tmp : tmp[0]);
    }

    public static Object convert(ResultSet resultSet, boolean simplifying) throws ConversionException {
        Object[] tmp = ResultSetConverter.convertToArray(resultSet);
        return !simplifying || tmp.length > 1 ? tmp : tmp[0];
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private static Object[] convertToArray(ResultSet resultSet) throws ConversionException {
        try {
            int columnCount = resultSet.getMetaData().getColumnCount();
            Object[] cells = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                cells[i] = resultSet.getObject(i + 1);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Converted: " + ArrayFormat.format((Object[])cells));
            }
            return cells;
        }
        catch (SQLException e) {
            throw new ConversionException((Throwable)e);
        }
    }
}

