/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.dialect;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.databene.commons.ArrayBuilder;
import org.databene.jdbacl.DBUtil;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.model.DBSchema;
import org.databene.jdbacl.model.DBSequence;
import org.databene.jdbacl.model.DBTrigger;
import org.databene.jdbacl.sql.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubridDialect
extends DatabaseDialect {
    public CubridDialect() {
        super("cubrid", true, true, "''yyyy-MM-dd''", "''HH:mm:ss''", "''yyyy-MM-dd HH:mm:ss''");
    }

    @Override
    public boolean isDefaultCatalog(String catalog, String user) {
        return true;
    }

    @Override
    public boolean isDefaultSchema(String schema, String user) {
        return true;
    }

    @Override
    public DBSequence[] querySequences(Connection connection) throws SQLException {
        String query = "select name, owner, current_val, increment_val, max_val, min_val, cyclic, class_name, att_name, cached_num from db_serial";
        ResultSet resultSet = DBUtil.executeQuery(query, connection);
        ArrayBuilder builder = new ArrayBuilder(DBSequence.class);
        while (resultSet.next()) {
            DBSequence sequence = new DBSequence(resultSet.getString(1), null);
            sequence.setLastNumber(new BigInteger(resultSet.getString(3)));
            sequence.setIncrement(new BigInteger(resultSet.getString(4)));
            sequence.setMaxValue(new BigInteger(resultSet.getString(5)));
            sequence.setMinValue(new BigInteger(resultSet.getString(6)));
            sequence.setCycle(resultSet.getInt(7) != 0);
            sequence.setCache(resultSet.getLong(10));
        }
        return (DBSequence[])builder.toArray();
    }

    @Override
    public void createSequence(String name, long initialValue, Connection connection) throws SQLException {
        DBUtil.executeQuery("create serial " + name + " start with " + initialValue, connection);
    }

    @Override
    public String renderCreateSequence(DBSequence sequence) {
        Boolean cycle;
        Long cache;
        BigInteger increment;
        StringBuilder builder = new StringBuilder("CREATE SERIAL ");
        builder.append(this.renderSequenceNameAndType(sequence));
        BigInteger start = sequence.getStart();
        if (start != null && CubridDialect.isNotOne(start)) {
            builder.append(" START WITH ").append(start);
        }
        if ((increment = sequence.getIncrement()) != null && CubridDialect.isNotOne(increment)) {
            builder.append(" INCREMENT BY ").append(increment);
        }
        if (this.isSequenceBoundarySupported()) {
            BigInteger minValue;
            BigInteger maxValue = sequence.getMaxValue();
            if (maxValue != null) {
                builder.append(" MAXVALUE ").append(maxValue);
            }
            if ((minValue = sequence.getMinValue()) != null) {
                builder.append(" MINVALUE ").append(minValue);
            }
        }
        if ((cache = sequence.getCache()) != null) {
            builder.append(" CACHE ").append(cache);
        }
        if ((cycle = sequence.isCycle()) != null) {
            builder.append(cycle != false ? " CYCLE" : " " + this.sequenceNoCycle());
        }
        return builder.toString();
    }

    @Override
    public String renderFetchSequenceValue(String sequenceName) {
        return "SELECT " + sequenceName + ".NEXT_VALUE";
    }

    @Override
    public void setNextSequenceValue(String sequenceName, long value, Connection connection) throws SQLException {
        DBUtil.executeUpdate("ALTER SERIAL " + sequenceName + " START WITH " + value, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DBTrigger> queryTriggers(DBSchema schema, Connection connection) throws SQLException {
        String query = "SELECT t.owner, t.name, t.status, t.priority, t.event, c.class_name as table_name, t.target_attribute, t.target_class_attribute, t.condition_type, t.condition, t.condition_time, t.action_type, t.action_definition, t.action_time FROM db_trigger as t join _db_class as c on t.target_class = c.class_of";
        ResultSet resultSet = DBUtil.executeQuery(query, connection);
        ArrayList<DBTrigger> triggers = new ArrayList<DBTrigger>();
        try {
            while (resultSet.next()) {
                String actionTime;
                String actionType;
                String event;
                String triggerName = resultSet.getString("name");
                DBTrigger trigger = new DBTrigger(triggerName, null);
                trigger.setOwner(schema);
                schema.receiveTrigger(trigger);
                int statusFlag = resultSet.getInt("status");
                String status = statusFlag == 2 ? "ACTIVE" : "INACTIVE";
                trigger.setStatus(status);
                trigger.setPriority(resultSet.getDouble("priority"));
                int eventFlag = resultSet.getInt("event");
                switch (eventFlag) {
                    case 0: {
                        event = "UPDATE";
                        break;
                    }
                    case 1: {
                        event = "UPDATE STATEMENT";
                        break;
                    }
                    case 2: {
                        event = "DELETE";
                        break;
                    }
                    case 3: {
                        event = "DELETE STATEMENT";
                        break;
                    }
                    case 4: {
                        event = "INSERT";
                        break;
                    }
                    case 5: {
                        event = "INSERT STATEMENT";
                        break;
                    }
                    case 8: {
                        event = "COMMIT";
                        break;
                    }
                    case 9: {
                        event = "ROLLBACK";
                        break;
                    }
                    default: {
                        event = "<ERROR>";
                        this.logger.error("Illegal event flag in trigger {}: {}", (Object)triggerName, (Object)eventFlag);
                    }
                }
                trigger.setTriggeringEvent(event);
                trigger.setTableName(resultSet.getString("table_name"));
                trigger.setColumnName(resultSet.getString("target_attribute"));
                trigger.setStaticColumn(resultSet.getInt("target_class_attribute") == 1);
                trigger.setWhenClause(resultSet.getString("condition"));
                Object conditionTimeObject = resultSet.getObject("condition_time");
                if (conditionTimeObject != null) {
                    String conditionTime;
                    int conditionTimeFlag = ((Number)conditionTimeObject).intValue();
                    switch (conditionTimeFlag) {
                        case 1: {
                            conditionTime = "BEFORE";
                            break;
                        }
                        case 2: {
                            conditionTime = "AFTER";
                            break;
                        }
                        case 3: {
                            conditionTime = "DEFERRED";
                            break;
                        }
                        default: {
                            conditionTime = "<ERROR>";
                            this.logger.error("Illegal condition time flag in trigger {}: {}", (Object)triggerName, (Object)conditionTime);
                        }
                    }
                    trigger.setConditionTime(conditionTime);
                }
                int actionTypeFlag = resultSet.getInt("action_type");
                switch (actionTypeFlag) {
                    case 1: {
                        actionType = "INSERT OR UPDATE OR DELETE OR CALL OR EVALUATE";
                        break;
                    }
                    case 2: {
                        actionType = "REJECT";
                        break;
                    }
                    case 3: {
                        actionType = "INVALIDATE_TRANSACTION";
                        break;
                    }
                    case 4: {
                        actionType = "PRINT";
                        break;
                    }
                    default: {
                        actionType = "<ERROR>";
                        this.logger.error("Illegal action type flag in trigger {}: {}", (Object)triggerName, (Object)actionTypeFlag);
                    }
                }
                trigger.setActionType(actionType);
                trigger.setTriggerBody(resultSet.getString("action_definition"));
                int actionTimeFlag = resultSet.getInt("action_time");
                switch (actionTimeFlag) {
                    case 1: {
                        actionTime = "BEFORE";
                        break;
                    }
                    case 2: {
                        actionTime = "AFTER";
                        break;
                    }
                    case 3: {
                        actionTime = "DEFERRED";
                        break;
                    }
                    default: {
                        actionTime = "<ERROR>";
                        this.logger.error("Illegal action time flag in trigger {}: {}", (Object)triggerName, (Object)actionTime);
                    }
                }
                trigger.setTriggerType(actionTime);
                triggers.add(trigger);
                this.logger.debug("Imported trigger: {}", (Object)trigger.getName());
            }
        }
        finally {
            DBUtil.closeResultSetAndStatement(resultSet);
        }
        return triggers;
    }

    @Override
    public boolean isDeterministicPKName(String pkName) {
        return true;
    }

    @Override
    public boolean isDeterministicUKName(String ukName) {
        return true;
    }

    @Override
    public boolean isDeterministicFKName(String fkName) {
        return true;
    }

    @Override
    public boolean isDeterministicIndexName(String indexName) {
        return true;
    }

    @Override
    public String trim(String expression) {
        return "trim(" + expression + ")";
    }

    @Override
    public void restrictRownums(int offset, int rowCount, Query query) {
        if (offset == 0) {
            query.addOption("limit " + rowCount);
        } else {
            query.addOption("limit " + offset + ", " + rowCount);
        }
    }

    @Override
    public boolean supportsRegex() {
        return true;
    }

    @Override
    public String regexQuery(String expression, boolean not, String regex) {
        return expression + (not ? " NOT" : "") + " REGEX '" + regex + "'";
    }
}

