/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.dialect;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.databene.commons.ConfigurationError;
import org.databene.commons.ConnectFailedException;
import org.databene.jdbacl.DBUtil;

public class HSQLUtil {
    public static final String IN_MEMORY_URL_PREFIX = "jdbc:hsqldb:mem:";
    public static final String DRIVER = "org.hsqldb.jdbcDriver";
    public static final String DEFAULT_USER = "sa";
    public static final String DEFAULT_PASSWORD = "";
    public static final String DEFAULT_SCHEMA = "PUBLIC";
    public static final int DEFAULT_PORT = 9001;

    public static Connection connectInMemoryDB(String dbName, int port) throws ConnectFailedException {
        return HSQLUtil.connectInMemoryDB(dbName + ":" + port);
    }

    public static Connection connectInMemoryDB(String dbName) throws ConnectFailedException {
        String driver = DRIVER;
        try {
            Class.forName(driver);
            String url = HSQLUtil.getInMemoryURL(dbName);
            String user = DEFAULT_USER;
            String password = DEFAULT_PASSWORD;
            return DBUtil.connect(url, DRIVER, user, password, false);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationError("JDBC driver not found: " + driver, (Throwable)e);
        }
    }

    public static String getInMemoryURL(String dbName) {
        String url = IN_MEMORY_URL_PREFIX + dbName;
        return url;
    }

    public static Statement shutdown(String url, String user, String password) throws ClassNotFoundException, SQLException {
        Class.forName(DRIVER);
        Connection con = DriverManager.getConnection(url, user, password);
        Statement statement = con.createStatement();
        statement.executeUpdate("SHUTDOWN");
        return statement;
    }
}

