/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.dialect;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import org.databene.commons.ArrayBuilder;
import org.databene.jdbacl.DBUtil;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.model.DBSequence;
import org.databene.jdbacl.sql.Query;

public class PostgreSQLDialect
extends DatabaseDialect {
    private static final String DATE_PATTERN = "'date '''yyyy-MM-dd''";
    private static final String TIME_PATTERN = "'time '''HH:mm:ss''";
    private static final String DATETIME_PATTERN = "'timestamp '''yyyy-MM-dd HH:mm:ss''";

    public PostgreSQLDialect() {
        super("postgres", false, true, DATE_PATTERN, TIME_PATTERN, DATETIME_PATTERN);
    }

    protected String sequenceNoCycle() {
        return "NO CYCLE";
    }

    public String renderCreateSequence(DBSequence sequence) {
        String result = super.renderCreateSequence(sequence);
        Long cache = sequence.getCache();
        if (cache != null) {
            result = result + " CACHE " + cache;
        }
        return result;
    }

    public DBSequence[] querySequences(Connection connection) throws SQLException {
        List<Object[]> rows = DBUtil.query("select relname from pg_class where relkind = 'S'", connection);
        ArrayBuilder builder = new ArrayBuilder(DBSequence.class, rows.size());
        for (Object[] row : rows) {
            String name = (String)row[0];
            Object[] details = DBUtil.querySingleRow("select sequence_name, start_value, increment_by, max_value, min_value, is_cycled, cache_value, last_value from " + name, connection);
            DBSequence sequence = new DBSequence(name, null);
            sequence.setStart(new BigInteger(details[1].toString()));
            sequence.setIncrement(new BigInteger(details[2].toString()));
            sequence.setMaxValue(new BigInteger(details[3].toString()));
            sequence.setMinValue(new BigInteger(details[4].toString()));
            sequence.setCycle(Boolean.valueOf(details[5].toString()));
            sequence.setCache(Long.parseLong(details[6].toString()));
            sequence.setLastNumber(new BigInteger(details[7].toString()));
            builder.add((Object)sequence);
        }
        return (DBSequence[])builder.toArray();
    }

    public boolean isDefaultCatalog(String catalog, String user) {
        return "".equals(catalog) || user.equalsIgnoreCase(catalog);
    }

    public boolean isDefaultSchema(String schema, String user) {
        return "public".equalsIgnoreCase(schema);
    }

    public String renderFetchSequenceValue(String sequenceName) {
        return "select nextval('" + sequenceName + "')";
    }

    public String formatTimestamp(Timestamp timestamp) {
        return "timestamp " + super.formatTimestamp(timestamp);
    }

    public boolean isDeterministicPKName(String pkName) {
        return true;
    }

    public boolean isDeterministicUKName(String ukName) {
        return true;
    }

    public boolean isDeterministicFKName(String fkName) {
        return true;
    }

    public boolean isDeterministicIndexName(String indexName) {
        return true;
    }

    public boolean supportsRegex() {
        return true;
    }

    public String regexQuery(String expression, boolean not, String regex) {
        return (not ? "NOT " : "") + expression + " ~ '" + regex + "'";
    }

    public void restrictRownums(int firstRowIndex, int rowCount, Query query) {
        throw new UnsupportedOperationException("PostgreSQLDialect.applyRownumRestriction() is not implemented");
    }
}

