/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.identity;

import java.sql.Connection;
import java.util.HashSet;
import java.util.Set;
import org.databene.commons.ArrayFormat;
import org.databene.commons.Assert;
import org.databene.commons.ErrorHandler;
import org.databene.commons.Level;
import org.databene.commons.Named;
import org.databene.commons.bean.HashCodeBuilder;
import org.databene.commons.iterator.TabularIterator;
import org.databene.jdbacl.ArrayResultSetIterator;
import org.databene.jdbacl.identity.KeyMapper;
import org.databene.jdbacl.model.DBRow;
import org.databene.jdbacl.model.Database;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IdentityModel
implements Named {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    ErrorHandler errorHandler = new ErrorHandler("DBMerger", Level.warn);
    String tableName;
    private Set<String> unimportantColumns;

    public IdentityModel(String tableName) {
        Assert.notNull((Object)tableName, (String)"tableName");
        this.tableName = tableName;
        this.unimportantColumns = new HashSet<String>();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getName() {
        return this.tableName;
    }

    public void addIrrelevantColumn(String unimportantColumn) {
        this.unimportantColumns.add(unimportantColumn);
    }

    public abstract TabularIterator createNkPkIterator(Connection var1, String var2, KeyMapper var3, Database var4);

    public String extractNK(Object[] nkPkTuple) {
        return String.valueOf(nkPkTuple[0]);
    }

    public Object extractPK(Object[] nkPkTuple) {
        if (nkPkTuple.length == 2) {
            return nkPkTuple[1];
        }
        if (nkPkTuple.length > 2) {
            Object[] pk = new Object[nkPkTuple.length - 1];
            for (int i = 0; i < nkPkTuple.length - 1; ++i) {
                pk[i] = nkPkTuple[1 + i];
            }
            return pk;
        }
        throw new UnsupportedOperationException("Table " + this.tableName + " does not have a primary key");
    }

    public abstract String getDescription();

    protected TabularIterator query(String query, Connection connection) {
        Assert.notEmpty((String)query, (String)"query");
        return new ArrayResultSetIterator(connection, query);
    }

    protected void handleNKNotFound(String naturalKey, String tableName, String sourceDbId, String targetDbId) {
        String message = "Missing entry: " + sourceDbId + '.' + tableName + "[" + naturalKey + "]" + " does not appear in " + targetDbId;
        this.errorHandler.handleError(message);
    }

    protected void handleNonEquivalence(String message, Object pk, DBRow entity) {
        this.errorHandler.handleError(message);
    }

    protected void handleMissingOwner(String ownedTableName, DBRow ownedEntity, String ownerTableName, Object ownerId, String sourceDbId) {
        String message = "Owner of " + sourceDbId + '.' + ownedTableName + '[' + ArrayFormat.format((Object[])ownedEntity.getPKValues()) + "] was dropped. " + "Missing: " + sourceDbId + '.' + ownerTableName + '[' + ownerId + "]. " + "Possibly it was rejected or it was missing in the NK query";
        this.errorHandler.handleError(message);
    }

    public int hashCode() {
        return HashCodeBuilder.hashCode((Object[])new Object[]{this.tableName});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IdentityModel that = (IdentityModel)obj;
        return this.tableName.equals(that.tableName);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.tableName + ")";
    }
}

