/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.identity.mem;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.databene.commons.bean.ObjectOrArray;
import org.databene.commons.iterator.TabularIterator;
import org.databene.jdbacl.identity.IdentityModel;
import org.databene.jdbacl.identity.KeyMapper;
import org.databene.jdbacl.identity.mem.MapperState;
import org.databene.jdbacl.model.Database;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTableMapper.class);
    protected KeyMapper root;
    protected Connection connection;
    protected String dbId;
    protected IdentityModel identity;
    private Map<ObjectOrArray, String> pkToNk;
    private MapperState state;
    Database database;

    public AbstractTableMapper(KeyMapper root, Connection connection, String dbId, IdentityModel identity, Database database) {
        this.root = root;
        this.connection = connection;
        this.dbId = dbId;
        this.identity = identity;
        this.database = database;
        this.pkToNk = new HashMap<ObjectOrArray, String>(1000);
        this.state = MapperState.CREATED;
    }

    public Object store(Object pk, String naturalKey) {
        if (this.state == MapperState.CREATED) {
            this.state = MapperState.PASSIVE;
        }
        ObjectOrArray globalRowId = new ObjectOrArray(pk);
        return this.pkToNk.put(globalRowId, naturalKey);
    }

    public String getNaturalKey(Object pk) {
        this.assureInitialized();
        return this.pkToNk.get(new ObjectOrArray(pk));
    }

    private void populate() {
        this.state = MapperState.POPULATING;
        LOGGER.debug("Populating key mapper for table {} on database {}", (Object)this.identity.getTableName(), (Object)this.dbId);
        TabularIterator iterator = this.identity.createNkPkIterator(this.connection, this.dbId, this.root, this.database);
        while (iterator.hasNext()) {
            Object[] nkPkTuple = (Object[])iterator.next();
            Object pk = this.identity.extractPK(nkPkTuple);
            String nk = this.identity.extractNK(nkPkTuple);
            this.store(pk, nk);
        }
        this.state = MapperState.POPULATED;
    }

    protected void assureInitialized() {
        if (this.state == MapperState.CREATED) {
            this.populate();
        }
    }
}

