/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.databene.commons.Named;
import org.databene.commons.ObjectNotFoundException;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.jdbacl.model.AbstractCompositeDBObject;
import org.databene.jdbacl.model.DBSchema;
import org.databene.jdbacl.model.DBSequence;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.Database;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCatalog
extends AbstractCompositeDBObject<DBSchema>
implements Named,
Serializable {
    private static final long serialVersionUID = 3956827426638393655L;
    OrderedNameMap<DBSchema> schemas;

    public DBCatalog() {
        this(null);
    }

    public DBCatalog(String name) {
        this(name, (Database)null);
    }

    public DBCatalog(String name, Database owner) {
        super(name, "catalog", owner);
        if (owner != null) {
            owner.addCatalog(this);
        }
        this.schemas = OrderedNameMap.createCaseIgnorantMap();
    }

    public Database getDatabase() {
        return (Database)this.getOwner();
    }

    public void setDatabase(Database database) {
        this.owner = database;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDoc() {
        return this.doc;
    }

    @Override
    public void setDoc(String doc) {
        this.doc = doc;
    }

    @Override
    public List<DBSchema> getComponents() {
        return this.schemas.values();
    }

    public List<DBSchema> getSchemas() {
        return this.getComponents();
    }

    public DBSchema getSchema(String schemaName) {
        return (DBSchema)this.schemas.get(schemaName);
    }

    public void addSchema(DBSchema schema) {
        this.schemas.put(schema.getName(), (Object)schema);
        schema.setOwner(this);
    }

    public void removeSchema(DBSchema schema) {
        this.schemas.remove(schema.getName());
    }

    public List<DBTable> getTables() {
        ArrayList<DBTable> tables = new ArrayList<DBTable>();
        for (DBSchema schema : this.getSchemas()) {
            for (DBTable table : schema.getTables()) {
                tables.add(table);
            }
        }
        return tables;
    }

    public DBTable getTable(String name) {
        return this.getTable(name, true);
    }

    public DBTable getTable(String name, boolean required) {
        for (DBSchema schema : this.getSchemas()) {
            for (DBTable table : schema.getTables()) {
                if (!table.getName().equals(name)) continue;
                return table;
            }
        }
        if (required) {
            throw new ObjectNotFoundException("Table '" + name + "'");
        }
        return null;
    }

    public void removeTable(String tableName) {
        DBTable table = this.getTable(tableName);
        table.getSchema().removeTable(table);
    }

    public List<DBSequence> getSequences() {
        ArrayList<DBSequence> sequences = new ArrayList<DBSequence>();
        for (DBSchema schema : this.getSchemas()) {
            for (DBSequence table : schema.getSequences(true)) {
                sequences.add(table);
            }
        }
        return sequences;
    }
}

