/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.util.Arrays;
import org.databene.commons.ArrayUtil;
import org.databene.commons.NullSafeComparator;
import org.databene.jdbacl.model.DBIndex;
import org.databene.jdbacl.model.DBObject;
import org.databene.jdbacl.model.DBTable;

public class DBNonUniqueIndex
extends DBIndex {
    private static final long serialVersionUID = -6326915676663722678L;
    private String[] columnNames;

    public DBNonUniqueIndex(String name, boolean nameDeterministic, DBTable table, String ... columnNames) {
        super(name, nameDeterministic, table);
        this.columnNames = columnNames;
    }

    public boolean isUnique() {
        return false;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void addColumnName(String columnName) {
        this.columnNames = (String[])ArrayUtil.append((Object)columnName, (Object[])this.columnNames);
    }

    public boolean isIdentical(DBObject other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof DBNonUniqueIndex)) {
            return false;
        }
        DBNonUniqueIndex that = (DBNonUniqueIndex)other;
        return NullSafeComparator.equals((Object)this.name, (Object)that.name) && Arrays.equals(this.columnNames, that.getColumnNames()) && NullSafeComparator.equals((Object)this.getOwner().getName(), (Object)that.getOwner().getName());
    }
}

