/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.io.Serializable;
import java.util.Map;
import org.databene.commons.Assert;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.jdbacl.model.DBForeignKeyConstraint;
import org.databene.jdbacl.model.DBTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBRow
implements Serializable {
    private static final long serialVersionUID = 644247555736773166L;
    DBTable table;
    OrderedNameMap<Object> cells;

    public DBRow(DBTable table) {
        this.table = table;
        this.cells = OrderedNameMap.createCaseIgnorantMap();
    }

    public DBTable getTable() {
        return this.table;
    }

    public DBRow withTable(DBTable table) {
        this.table = table;
        return this;
    }

    public Map<String, Object> getCells() {
        return this.cells;
    }

    public Object[] getPKValues() {
        return this.getCellValues(this.table.getPKColumnNames());
    }

    public Object getPKValue() {
        String[] columnNames = this.table.getPKColumnNames();
        if (columnNames.length == 1) {
            return this.getCellValue(columnNames[0]);
        }
        return this.getCellValues(columnNames);
    }

    public Object getFKValue(DBForeignKeyConstraint fk) {
        String[] columnNames = fk.getColumnNames();
        if (columnNames.length == 1) {
            return this.getCellValue(columnNames[0]);
        }
        return this.getCellValues(columnNames);
    }

    public void setFKValue(DBForeignKeyConstraint fkConstraint, Object fkValue) {
        String[] columnNames = fkConstraint.getColumnNames();
        if (columnNames.length == 1) {
            this.setCellValue(columnNames[0], fkValue);
        } else {
            Object[] cellValues = (Object[])fkValue;
            this.setCellValues(columnNames, cellValues);
        }
    }

    public Object[] getFKComponents(DBForeignKeyConstraint fk) {
        return this.getCellValues(fk.getColumnNames());
    }

    public void setCellValues(String[] columnNames, Object[] cellValues) {
        Assert.equals((Object)columnNames.length, (Object)cellValues.length, (String)"mismatch of column and value counts");
        for (int i = 0; i < columnNames.length; ++i) {
            this.setCellValue(columnNames[i], cellValues[i]);
        }
    }

    private Object[] getCellValues(String[] columnNames) {
        Object[] result = new Object[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            result[i] = this.cells.get(columnNames[i]);
        }
        return result;
    }

    public Object getCellValue(String columnName) {
        return this.cells.get(columnName);
    }

    public void setCellValue(String columnName, Object value) {
        this.cells.put(columnName, value);
    }

    public String toString() {
        return this.table.getName() + this.cells.values();
    }

    public void setPKValue(Object newPK) {
        String[] columnNames = this.table.getPKColumnNames();
        if (columnNames.length == 1) {
            this.setCellValue(columnNames[0], newPK);
        } else {
            this.setCellValues(columnNames, (Object[])newPK);
        }
    }
}

