/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.databene.commons.HeavyweightIterator;
import org.databene.jdbacl.DBUtil;
import org.databene.jdbacl.ResultSetIterator;
import org.databene.jdbacl.model.DBRow;
import org.databene.jdbacl.model.DBTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBRowIterator
implements HeavyweightIterator<DBRow> {
    private static final Logger SQL_LOGGER = LoggerFactory.getLogger((String)"org.databene.SQL");
    private DBTable table;
    private ResultSet resultSet;
    private ResultSetMetaData resultSetMetaData;
    private ResultSetIterator resultSetIterator;
    private boolean closed;

    public DBRowIterator(DBTable table, Connection connection, String whereClause) throws SQLException {
        this.table = table;
        String sql = "SELECT * FROM " + table.getName();
        if (whereClause != null) {
            sql = sql + " WHERE " + whereClause;
        }
        SQL_LOGGER.debug(sql);
        Statement statement = connection.createStatement(1003, 1007, 1);
        statement.setFetchSize(1000);
        this.resultSet = statement.executeQuery(sql);
        this.resultSetMetaData = this.resultSet.getMetaData();
        this.resultSetIterator = new ResultSetIterator(this.resultSet, sql);
        this.closed = false;
    }

    public DBRowIterator withTable(DBTable table) {
        this.table = table;
        return this;
    }

    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        boolean result = this.resultSetIterator.hasNext();
        if (!result) {
            this.close();
        }
        return result;
    }

    public DBRow next() {
        try {
            this.resultSetIterator.next();
            DBRow row = new DBRow(this.table);
            int columnCount = this.resultSetMetaData.getColumnCount();
            for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                String columnName = this.resultSetMetaData.getColumnName(columnIndex);
                row.setCellValue(columnName, this.resultSet.getObject(columnIndex));
            }
            return row;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error querying table " + this.table, e);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported by " + this.getClass());
    }

    public void close() {
        if (!this.closed) {
            DBUtil.closeResultSetAndStatement(this.resultSet);
            this.resultSet = null;
            this.closed = true;
        }
    }
}

