/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.util.Arrays;
import org.databene.commons.NullSafeComparator;
import org.databene.jdbacl.model.DBIndex;
import org.databene.jdbacl.model.DBObject;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.DBUniqueConstraint;

public class DBUniqueIndex
extends DBIndex {
    private static final long serialVersionUID = -1758033589908866869L;
    private DBUniqueConstraint constraint;

    public DBUniqueIndex(String name, boolean nameDeterministic, DBUniqueConstraint constraint) {
        super(name, nameDeterministic, constraint.getTable());
        this.constraint = constraint;
    }

    public boolean isUnique() {
        return true;
    }

    public DBTable getTable() {
        return (DBTable)this.constraint.getOwner();
    }

    public String[] getColumnNames() {
        return this.constraint.getColumnNames();
    }

    public void addColumnName(String columnName) {
        if (this.constraint == null) {
            this.constraint = new DBUniqueConstraint(this.getTable(), this.name, this.isNameDeterministic(), columnName);
        } else {
            this.constraint.addColumnName(columnName);
        }
    }

    public boolean isIdentical(DBObject other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof DBUniqueIndex)) {
            return false;
        }
        DBUniqueIndex that = (DBUniqueIndex)other;
        return NullSafeComparator.equals((Object)this.name, (Object)that.name) && Arrays.equals(this.getColumnNames(), that.getColumnNames()) && NullSafeComparator.equals((Object)this.getOwner().getName(), (Object)that.getOwner().getName());
    }
}

