/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model.cache;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.databene.commons.ConnectFailedException;
import org.databene.commons.FileUtil;
import org.databene.commons.ImportFailedException;
import org.databene.commons.Period;
import org.databene.commons.StringUtil;
import org.databene.commons.SystemInfo;
import org.databene.jdbacl.model.DBMetaDataImporter;
import org.databene.jdbacl.model.Database;
import org.databene.jdbacl.model.jdbc.JDBCDBImporter;
import org.databene.jdbacl.model.xml.XMLModelExporter;
import org.databene.jdbacl.model.xml.XMLModelImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingDBImporter
implements DBMetaDataImporter,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingDBImporter.class);
    public static final String TIME_TO_LIVE_SYSPROP = "jdbacl.cache.timetolive";
    public static final long DEFAULT_TIME_TO_LIVE = Period.HOUR.getMillis() * 12L;
    private static final String CACHE_FILE_SUFFIX = ".meta.xml";
    protected JDBCDBImporter realImporter;
    protected String environment;

    public CachingDBImporter(JDBCDBImporter realImporter, String environment) {
        this.realImporter = realImporter;
        this.environment = environment;
    }

    public Database importDatabase() throws ConnectFailedException, ImportFailedException {
        File file = this.getCacheFile();
        long now = System.currentTimeMillis();
        long timeToLive = this.getTimeToLive();
        if (file.exists() && (timeToLive < 0L || now - file.lastModified() < timeToLive)) {
            return this.readCachedData(file);
        }
        return this.importFreshData(file);
    }

    private long getTimeToLive() {
        String sysProp = System.getProperty(TIME_TO_LIVE_SYSPROP);
        if (!StringUtil.isEmpty((CharSequence)sysProp)) {
            long scale = 1L;
            if (sysProp.endsWith("d")) {
                scale = Period.DAY.getMillis();
                sysProp = sysProp.substring(0, sysProp.length() - 1);
            }
            return Long.parseLong(sysProp) * scale;
        }
        return DEFAULT_TIME_TO_LIVE;
    }

    public void close() throws IOException {
        if (this.realImporter instanceof Closeable) {
            this.realImporter.close();
        }
    }

    public static File getCacheFile(String environment) {
        String SEP = File.separator;
        String cacheDirName = SystemInfo.getUserHome() + SEP + "databene" + SEP + "cache";
        String cacheFileName = environment + CACHE_FILE_SUFFIX;
        return FileUtil.getFileIgnoreCase((File)new File(cacheDirName, cacheFileName), (boolean)false);
    }

    protected File getCacheFile() {
        return CachingDBImporter.getCacheFile(this.environment);
    }

    protected Database readCachedData(File cacheFile) throws ConnectFailedException, ImportFailedException {
        try {
            LOGGER.info("Importing database meta data from cache file " + cacheFile.getPath());
            Database database = new XMLModelImporter(cacheFile, this.realImporter).importDatabase();
            LOGGER.info("Database meta data import completed");
            return database;
        }
        catch (Exception e) {
            LOGGER.info("Error reading cache file, reparsing database", (Throwable)e);
            return this.importFreshData(cacheFile);
        }
    }

    protected Database importFreshData(File file) throws ConnectFailedException, ImportFailedException {
        Database database = this.realImporter.importDatabase();
        return CachingDBImporter.writeCacheFile(file, database);
    }

    public static void updateCacheFile(Database database) {
        if (database == null) {
            throw new IllegalArgumentException("database is null");
        }
        String environment = database.getEnvironment();
        if (environment != null) {
            File cacheFile = CachingDBImporter.getCacheFile(environment);
            CachingDBImporter.writeCacheFile(cacheFile, database);
        }
    }

    public static Database writeCacheFile(File file, Database database) {
        LOGGER.info("Exporting Database meta data of " + database.getEnvironment() + " to cache file");
        try {
            FileUtil.ensureDirectoryExists((File)file.getParentFile());
            new XMLModelExporter(file).export(database);
            LOGGER.debug("Database meta data export completed");
        }
        catch (Exception e) {
            LOGGER.error("Error writing database meta data file : " + e.getMessage(), (Throwable)e);
        }
        return database;
    }
}

