/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model.sql;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Set;
import org.databene.commons.IOUtil;
import org.databene.jdbacl.DBUtil;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.DatabaseDialectManager;
import org.databene.jdbacl.NameSpec;
import org.databene.jdbacl.SQLUtil;
import org.databene.jdbacl.model.DBForeignKeyConstraint;
import org.databene.jdbacl.model.DBMetaDataExporter;
import org.databene.jdbacl.model.DBSequence;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.Database;

public class CreateExporter
implements DBMetaDataExporter {
    File file;

    public CreateExporter(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(Database database) throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(this.file));
            this.exportSequences(database, out);
            this.exportTables(database, out);
            this.exportForeignKeys(database, out);
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((Closeable)out);
    }

    private void exportSequences(Database database, PrintWriter out) {
        List<DBSequence> sequences = database.getSequences(true);
        DatabaseDialect dialect = DatabaseDialectManager.getDialectForProduct(database.getDatabaseProductName(), database.getDatabaseProductVersion());
        for (DBSequence sequence : sequences) {
            out.print(dialect.renderCreateSequence(sequence));
            out.println(';');
            out.println();
        }
    }

    private void exportTables(Database database, PrintWriter out) {
        List<DBTable> tables = DBUtil.dependencyOrderedTables(database);
        for (DBTable table : tables) {
            SQLUtil.renderCreateTable(table, false, NameSpec.IF_REPRODUCIBLE, out);
            out.println(';');
            out.println();
        }
    }

    private void exportForeignKeys(Database database, PrintWriter out) {
        for (DBTable table : database.getTables()) {
            this.exportForeignKeys(table, out);
        }
    }

    private void exportForeignKeys(DBTable table, PrintWriter out) {
        Set<DBForeignKeyConstraint> fks = table.getForeignKeyConstraints();
        for (DBForeignKeyConstraint fk : fks) {
            SQLUtil.renderAddForeignKey(fk, NameSpec.IF_REPRODUCIBLE, out);
            out.println(';');
            out.println();
        }
    }
}

