/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model.xml;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Set;
import org.databene.commons.ArrayUtil;
import org.databene.commons.Assert;
import org.databene.commons.ConfigurationError;
import org.databene.commons.IOUtil;
import org.databene.commons.ImportFailedException;
import org.databene.commons.StringUtil;
import org.databene.commons.SyntaxError;
import org.databene.commons.xml.XMLUtil;
import org.databene.jdbacl.model.DBCatalog;
import org.databene.jdbacl.model.DBCheckConstraint;
import org.databene.jdbacl.model.DBColumn;
import org.databene.jdbacl.model.DBForeignKeyConstraint;
import org.databene.jdbacl.model.DBIndex;
import org.databene.jdbacl.model.DBMetaDataImporter;
import org.databene.jdbacl.model.DBNonUniqueIndex;
import org.databene.jdbacl.model.DBPackage;
import org.databene.jdbacl.model.DBPrimaryKeyConstraint;
import org.databene.jdbacl.model.DBProcedure;
import org.databene.jdbacl.model.DBSchema;
import org.databene.jdbacl.model.DBSequence;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.DBTrigger;
import org.databene.jdbacl.model.DBUniqueConstraint;
import org.databene.jdbacl.model.DBUniqueIndex;
import org.databene.jdbacl.model.Database;
import org.databene.jdbacl.model.FKChangeRule;
import org.databene.jdbacl.model.TableType;
import org.databene.jdbacl.model.jdbc.JDBCDBImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLModelImporter
implements DBMetaDataImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLModelImporter.class);
    private String uri;
    private JDBCDBImporter realImporter;

    public XMLModelImporter(File file, JDBCDBImporter realImporter) {
        this(file.getAbsolutePath(), realImporter);
    }

    public XMLModelImporter(String uri, JDBCDBImporter realImporter) {
        this.uri = uri;
        this.realImporter = realImporter;
    }

    public Database importDatabase() throws ImportFailedException {
        InputStream in = null;
        try {
            in = IOUtil.getInputStreamForURI((String)this.uri);
            Document doc = XMLUtil.parse((InputStream)in);
            Database database = this.parseDatabase(doc.getDocumentElement());
            return database;
        }
        catch (IOException e) {
            throw new ImportFailedException((Throwable)e);
        }
        finally {
            IOUtil.close((Closeable)in);
        }
    }

    private Database parseDatabase(Element e) {
        String environment = e.getAttribute("environment");
        if (StringUtil.isEmpty((CharSequence)environment)) {
            environment = e.getAttribute("name");
        }
        if (StringUtil.isEmpty((CharSequence)environment)) {
            throw new ConfigurationError("No environment defined in cache file");
        }
        Database db = new Database(environment, this.realImporter, false);
        db.setUser(e.getAttribute("user"));
        db.setTableInclusionPattern(e.getAttribute("tableInclusionPattern"));
        db.setTableExclusionPattern(e.getAttribute("tableExclusionPattern"));
        db.setSequencesImported(XMLUtil.getBooleanAttribute((Element)e, (String)"sequencesImported", (boolean)true));
        db.setTriggersImported(XMLUtil.getBooleanAttribute((Element)e, (String)"triggersImported", (boolean)true));
        db.setPackagesImported(XMLUtil.getBooleanAttribute((Element)e, (String)"packagesImported", (boolean)true));
        db.setChecksImported(XMLUtil.getBooleanAttribute((Element)e, (String)"checksImported", (boolean)true));
        for (Element child : XMLUtil.getChildElements((Element)e)) {
            String childName = child.getNodeName();
            if (!"catalog".equals(childName)) {
                throw new UnsupportedOperationException("Not an allowed element within <database>: " + childName);
            }
            this.parseCatalog(child, db);
        }
        this.scanReferers(db);
        return db;
    }

    private DBCatalog parseCatalog(Element e, Database db) {
        String name = StringUtil.emptyToNull((String)e.getAttribute("name"));
        DBCatalog catalog = new DBCatalog(name, db);
        for (Element child : XMLUtil.getChildElements((Element)e)) {
            String childName = child.getNodeName();
            if (!"schema".equals(childName)) {
                throw new UnsupportedOperationException("Not an allowed element within <catalog>: " + childName);
            }
            this.parseSchema(child, catalog);
        }
        return catalog;
    }

    private DBSchema parseSchema(Element e, DBCatalog catalog) {
        String childName;
        Element[] children;
        String name = e.getAttribute("name");
        DBSchema schema = new DBSchema(name, catalog);
        for (Element child : children = XMLUtil.getChildElements((Element)e)) {
            childName = child.getNodeName();
            if ("table".equals(childName)) {
                this.parseTableName(child, schema);
                continue;
            }
            if ("sequence".equals(childName) || "trigger".equals(childName) || "package".equals(childName)) continue;
            throw new UnsupportedOperationException("Not an allowed element within <schema>: " + childName);
        }
        for (Element child : children) {
            childName = child.getNodeName();
            if ("table".equals(childName)) {
                this.parseTableStructure(child, schema);
                continue;
            }
            if ("sequence".equals(childName)) {
                this.parseSequence(child, schema);
                continue;
            }
            if ("trigger".equals(childName)) {
                this.parseTrigger(child, schema);
                continue;
            }
            if ("package".equals(childName)) {
                this.parsePackage(child, schema);
                continue;
            }
            throw new UnsupportedOperationException("Not an allowed element within <schema>: " + childName);
        }
        return schema;
    }

    private DBTable parseTableName(Element e, DBSchema schema) {
        String name = e.getAttribute("name");
        String typeSpec = e.getAttribute("type");
        TableType type = StringUtil.isEmpty((CharSequence)typeSpec) ? TableType.TABLE : TableType.valueOf(typeSpec);
        return new DBTable(name, type, null, schema, schema.getDatabase().getImporter());
    }

    private DBTable parseTableStructure(Element e, DBSchema schema) {
        String name = e.getAttribute("name");
        DBTable table = schema.getTable(name);
        boolean pkImported = XMLUtil.getBooleanAttributeWithDefault((Element)e, (String)"pkImported", (boolean)true);
        table.setPKImported(pkImported);
        boolean fksImported = XMLUtil.getBooleanAttributeWithDefault((Element)e, (String)"fksImported", (boolean)true);
        table.setFKsImported(fksImported);
        boolean indexesImported = XMLUtil.getBooleanAttributeWithDefault((Element)e, (String)"indexesImported", (boolean)true);
        table.setIndexesImported(indexesImported);
        boolean checksImported = XMLUtil.getBooleanAttributeWithDefault((Element)e, (String)"checksImported", (boolean)true);
        table.setChecksImported(checksImported);
        for (Element child : XMLUtil.getChildElements((Element)e)) {
            String childName = child.getNodeName();
            if ("column".equals(childName)) {
                this.parseColumn(child, table);
                continue;
            }
            if ("pk".equals(childName)) {
                this.parsePK(child, table);
                continue;
            }
            if ("uk".equals(childName)) {
                this.parseUK(child, table);
                continue;
            }
            if ("fk".equals(childName)) {
                this.parseFK(child, table, schema);
                continue;
            }
            if ("check".equals(childName)) {
                this.parseCheck(child, table);
                continue;
            }
            if ("index".equals(childName)) {
                this.parseIndex(child, table);
                continue;
            }
            throw new SyntaxError("Not an allowed element within <table>", XMLUtil.format((Element)child));
        }
        return table;
    }

    private DBColumn parseColumn(Element e, DBTable table) {
        String nullableSpec;
        String name = e.getAttribute("name");
        String typeAndSizeSpec = e.getAttribute("type");
        int jdbcType = Integer.parseInt(e.getAttribute("jdbcType"));
        DBColumn column = new DBColumn(name, table, jdbcType, typeAndSizeSpec);
        String defaultValue = e.getAttribute("default");
        if (!StringUtil.isEmpty((CharSequence)defaultValue)) {
            column.setDefaultValue(defaultValue);
        }
        boolean nullable = (nullableSpec = e.getAttribute("nullable")) == null || !"false".equals(nullableSpec);
        column.setNullable(nullable);
        return column;
    }

    private DBPrimaryKeyConstraint parsePK(Element e, DBTable table) {
        boolean autoNamed = false;
        if (e.getAttribute("autoNamed") != null) {
            autoNamed = Boolean.valueOf(e.getAttribute("autoNamed"));
        }
        return new DBPrimaryKeyConstraint(table, e.getAttribute("name"), autoNamed, this.parseColumnNames(e));
    }

    private DBUniqueConstraint parseUK(Element e, DBTable table) {
        boolean autoNamed = false;
        if (e.getAttribute("autoNamed") != null) {
            autoNamed = Boolean.valueOf(e.getAttribute("autoNamed"));
        }
        return new DBUniqueConstraint(table, e.getAttribute("name"), autoNamed, this.parseColumnNames(e));
    }

    private DBForeignKeyConstraint parseFK(Element e, DBTable owner, DBSchema schema) {
        String deleteRule;
        String name = e.getAttribute("name");
        String refereeTableName = e.getAttribute("refereeTable");
        DBTable refereeTable = schema.getTable(refereeTableName);
        Assert.notNull((Object)refereeTable, (String)"refereeTable");
        String colAttr = e.getAttribute("column");
        Object[] columnNames = null;
        Object[] refereeColumnNames = null;
        if (!StringUtil.isEmpty((CharSequence)colAttr)) {
            columnNames = new String[]{colAttr};
            refereeColumnNames = new String[]{e.getAttribute("refereeColumn")};
        } else {
            Element[] colElements;
            Element colsElement = XMLUtil.getChildElement((Element)e, (boolean)false, (boolean)true, (String)"columns");
            for (Element colElement : colElements = XMLUtil.getChildElements((Element)colsElement, (boolean)false, (String)"column")) {
                columnNames = (String[])ArrayUtil.append((Object)colElement.getAttribute("name"), (Object[])columnNames);
                refereeColumnNames = (String[])ArrayUtil.append((Object)colElement.getAttribute("refereeColumn"), (Object[])refereeColumnNames);
            }
        }
        boolean autoNamed = false;
        if (e.getAttribute("autoNamed") != null) {
            autoNamed = Boolean.valueOf(e.getAttribute("autoNamed"));
        }
        DBForeignKeyConstraint fk = new DBForeignKeyConstraint(name, autoNamed, owner, (String[])columnNames, refereeTable, (String[])refereeColumnNames);
        String updateRule = XMLUtil.getAttribute((Element)e, (String)"updateRule", (boolean)false);
        if (!StringUtil.isEmpty((CharSequence)updateRule)) {
            fk.setUpdateRule(FKChangeRule.valueOf(updateRule));
        }
        if (!StringUtil.isEmpty((CharSequence)(deleteRule = XMLUtil.getAttribute((Element)e, (String)"deleteRule", (boolean)false)))) {
            fk.setDeleteRule(FKChangeRule.valueOf(deleteRule));
        }
        return fk;
    }

    private DBCheckConstraint parseCheck(Element e, DBTable table) {
        try {
            table.getCatalog().getDatabase().setChecksImported(true);
            boolean autoNamed = false;
            if (e.getAttribute("autoNamed") != null) {
                autoNamed = Boolean.valueOf(e.getAttribute("autoNamed"));
            }
            return new DBCheckConstraint(e.getAttribute("name"), autoNamed, table, e.getAttribute("definition"));
        }
        catch (Exception ex) {
            LOGGER.error("Error parsing check constraint", (Throwable)ex);
            return null;
        }
    }

    private DBIndex parseIndex(Element e, DBTable table) {
        String name = e.getAttribute("name");
        String uniqueSpec = e.getAttribute("unique");
        boolean unique = uniqueSpec != null && "true".equals(uniqueSpec);
        String nameDeterministicSpec = e.getAttribute("nameDeterministic");
        boolean nameDeterministic = nameDeterministicSpec == null || "true".equals(nameDeterministicSpec);
        String[] columnNames = this.parseColumnNames(e);
        if (unique) {
            return new DBUniqueIndex(name, nameDeterministic, table.getUniqueConstraint(columnNames));
        }
        return new DBNonUniqueIndex(name, nameDeterministic, table, columnNames);
    }

    public String[] parseColumnNames(Element e) {
        String colAttr = e.getAttribute("column");
        Object[] columnNames = null;
        if (!StringUtil.isEmpty((CharSequence)colAttr)) {
            columnNames = new String[]{colAttr};
        } else {
            Element[] colElements;
            Element colsElement = XMLUtil.getChildElement((Element)e, (boolean)false, (boolean)true, (String)"columns");
            for (Element colElement : colElements = XMLUtil.getChildElements((Element)colsElement, (boolean)false, (String)"column")) {
                columnNames = (String[])ArrayUtil.append((Object)colElement.getAttribute("name"), (Object[])columnNames);
            }
        }
        return columnNames;
    }

    private void scanReferers(Database database) {
        for (DBTable table : database.getTables()) {
            Set<DBForeignKeyConstraint> fks = table.getForeignKeyConstraints();
            for (DBForeignKeyConstraint fk : fks) {
                fk.getRefereeTable().receiveReferrer(table);
            }
        }
        for (DBTable table : database.getTables()) {
            if (table.areReferrersImported()) continue;
            table.setReferrersImported(true);
        }
    }

    private DBSequence parseSequence(Element e, DBSchema schema) {
        String order;
        String cache;
        String cycle;
        String minValue;
        String maxValue;
        String increment;
        DBSequence sequence = new DBSequence(e.getAttribute("name"), schema);
        String start = e.getAttribute("start");
        if (!StringUtil.isEmpty((CharSequence)start)) {
            sequence.setStart(new BigInteger(start));
        }
        if (!StringUtil.isEmpty((CharSequence)(increment = e.getAttribute("increment")))) {
            sequence.setIncrement(new BigInteger(increment));
        }
        if (!StringUtil.isEmpty((CharSequence)(maxValue = e.getAttribute("maxValue")))) {
            sequence.setMaxValue(new BigInteger(maxValue));
        }
        if (!StringUtil.isEmpty((CharSequence)(minValue = e.getAttribute("minValue")))) {
            sequence.setMinValue(new BigInteger(minValue));
        }
        if (!StringUtil.isEmpty((CharSequence)(cycle = e.getAttribute("cycle")))) {
            sequence.setCycle(Boolean.parseBoolean(cycle));
        }
        if (!StringUtil.isEmpty((CharSequence)(cache = e.getAttribute("cache")))) {
            sequence.setCache(Long.parseLong(cache));
        }
        if (!StringUtil.isEmpty((CharSequence)(order = e.getAttribute("order")))) {
            sequence.setOrder(Boolean.parseBoolean(order));
        }
        return sequence;
    }

    private DBTrigger parseTrigger(Element e, DBSchema schema) {
        String triggerBody;
        String actionType;
        String description;
        String status;
        String whenClause;
        String referencingNames;
        String columnName;
        String tableName;
        String baseObjectType;
        String tableOwner;
        String triggeringEvent;
        DBTrigger trigger = new DBTrigger(e.getAttribute("name"), null);
        schema.receiveTrigger(trigger);
        trigger.setOwner(schema);
        String triggerType = e.getAttribute("triggerType");
        if (!StringUtil.isEmpty((CharSequence)triggerType)) {
            trigger.setTriggerType(triggerType);
        }
        if (!StringUtil.isEmpty((CharSequence)(triggeringEvent = e.getAttribute("triggeringEvent")))) {
            trigger.setTriggeringEvent(triggeringEvent);
        }
        if (!StringUtil.isEmpty((CharSequence)(tableOwner = e.getAttribute("tableOwner")))) {
            trigger.setTableOwner(tableOwner);
        }
        if (!StringUtil.isEmpty((CharSequence)(baseObjectType = e.getAttribute("baseObjectType")))) {
            trigger.setBaseObjectType(baseObjectType);
        }
        if (!StringUtil.isEmpty((CharSequence)(tableName = e.getAttribute("tableName")))) {
            trigger.setTableName(tableName);
        }
        if (!StringUtil.isEmpty((CharSequence)(columnName = e.getAttribute("columnName")))) {
            trigger.setColumnName(columnName);
        }
        if (!StringUtil.isEmpty((CharSequence)(referencingNames = e.getAttribute("referencingNames")))) {
            trigger.setReferencingNames(referencingNames);
        }
        if (!StringUtil.isEmpty((CharSequence)(whenClause = e.getAttribute("whenClause")))) {
            trigger.setWhenClause(whenClause);
        }
        if (!StringUtil.isEmpty((CharSequence)(status = e.getAttribute("status")))) {
            trigger.setStatus(status);
        }
        if (!StringUtil.isEmpty((CharSequence)(description = e.getAttribute("description")))) {
            trigger.setDescription(description);
        }
        if (!StringUtil.isEmpty((CharSequence)(actionType = e.getAttribute("actionType")))) {
            trigger.setActionType(actionType);
        }
        if (!StringUtil.isEmpty((CharSequence)(triggerBody = e.getAttribute("triggerBody")))) {
            trigger.setTriggerBody(triggerBody);
        }
        return trigger;
    }

    private DBPackage parsePackage(Element e, DBSchema schema) {
        String status;
        String objectType;
        String dataObjectId;
        String objectId;
        DBPackage pkg = new DBPackage(e.getAttribute("name"), null);
        pkg.setSchema(schema);
        schema.receivePackage(pkg);
        String subObjectName = e.getAttribute("subObjectName");
        if (!StringUtil.isEmpty((CharSequence)subObjectName)) {
            pkg.setSubObjectName(subObjectName);
        }
        if (!StringUtil.isEmpty((CharSequence)(objectId = e.getAttribute("objectId")))) {
            pkg.setObjectId(objectId);
        }
        if (!StringUtil.isEmpty((CharSequence)(dataObjectId = e.getAttribute("dataObjectId")))) {
            pkg.setDataObjectId(dataObjectId);
        }
        if (!StringUtil.isEmpty((CharSequence)(objectType = e.getAttribute("objectType")))) {
            pkg.setObjectType(objectType);
        }
        if (!StringUtil.isEmpty((CharSequence)(status = e.getAttribute("status")))) {
            pkg.setStatus(status);
        }
        this.parsePackageProcedures(e, pkg);
        return pkg;
    }

    private void parsePackageProcedures(Element pkgElement, DBPackage pkg) {
        for (Element e : XMLUtil.getChildElements((Element)pkgElement)) {
            String nodeName = e.getNodeName();
            if ("procedure".equals(nodeName)) {
                String overload;
                String subProgramId;
                DBProcedure procedure = new DBProcedure(e.getAttribute("name"), pkg);
                String objectId = e.getAttribute("objectId");
                if (!StringUtil.isEmpty((CharSequence)objectId)) {
                    procedure.setObjectId(objectId);
                }
                if (!StringUtil.isEmpty((CharSequence)(subProgramId = e.getAttribute("subProgramId")))) {
                    procedure.setSubProgramId(subProgramId);
                }
                if (StringUtil.isEmpty((CharSequence)(overload = e.getAttribute("overload")))) continue;
                procedure.setOverload(overload);
                continue;
            }
            throw new SyntaxError("Illegal child element of <package>", XMLUtil.format((Element)e));
        }
    }

    public void close() throws IOException {
    }
}

