/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import org.databene.commons.BeanUtil;
import org.databene.commons.CollectionUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.debug.Debug;
import org.databene.commons.debug.ResourceMonitor;
import org.databene.jdbacl.DBUtil;
import org.databene.profile.Profiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingStatementHandler
implements InvocationHandler {
    private static final Logger sqlLogger = LoggerFactory.getLogger((String)"org.databene.SQL");
    private static final Logger jdbcLogger = LoggerFactory.getLogger((String)"org.databene.JDBC");
    private static volatile AtomicInteger openStatementCount = new AtomicInteger();
    private static ResourceMonitor openStatementMonitor;
    private Statement realStatement;
    private boolean readOnly;
    private String sql;
    private boolean closed;

    public LoggingStatementHandler(Statement realStatement, boolean readOnly) {
        this.realStatement = realStatement;
        this.readOnly = readOnly;
        this.closed = false;
        openStatementCount.incrementAndGet();
        if (openStatementMonitor != null) {
            openStatementMonitor.register((Object)this);
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object result;
            String methodName = method.getName();
            Method localMethod = BeanUtil.findMethod(this.getClass(), (String)methodName, (Class[])method.getParameterTypes());
            boolean profile = methodName.startsWith("execute") && "true".equals(System.getProperty("profile"));
            long startTime = 0L;
            if (profile) {
                startTime = System.nanoTime();
            }
            if ((result = localMethod != null ? BeanUtil.invoke((Object)this, (Method)localMethod, (Object[])args) : BeanUtil.invoke((Object)this.realStatement, (Method)method, (Object[])args)) instanceof ResultSet) {
                result = DBUtil.createLoggingResultSet((ResultSet)result, (Statement)proxy);
            }
            if (profile) {
                long duration = (System.nanoTime() - startTime) / 1000000L;
                Profiler.defaultInstance().addSample(CollectionUtil.toList((Object[])new String[]{"SQL", this.sql}), duration);
            }
            return result;
        }
        catch (ConfigurationError e) {
            if (e.getCause() instanceof InvocationTargetException && e.getCause().getCause() instanceof SQLException) {
                throw e.getCause().getCause();
            }
            throw e;
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.logAll("execute", sql);
        DBUtil.checkReadOnly(sql, this.readOnly);
        this.sql = sql;
        return this.realStatement.execute(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.logAll("execute", sql);
        DBUtil.checkReadOnly(sql, this.readOnly);
        this.sql = sql;
        return this.realStatement.execute(sql, columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.logAll("execute", sql);
        DBUtil.checkReadOnly(sql, this.readOnly);
        this.sql = sql;
        return this.realStatement.execute(sql, columnNames);
    }

    public boolean execute(String sql) throws SQLException {
        this.logAll("execute", sql);
        DBUtil.checkReadOnly(sql, this.readOnly);
        this.sql = sql;
        return this.realStatement.execute(sql);
    }

    public int[] executeBatch() throws SQLException {
        jdbcLogger.debug("executeBatch()");
        return this.realStatement.executeBatch();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.logAll("executeQuery", sql);
        DBUtil.checkReadOnly(sql, this.readOnly);
        this.sql = sql;
        return this.realStatement.executeQuery(sql);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.logAll("executeUpdate", sql);
        DBUtil.checkReadOnly(sql, this.readOnly);
        this.sql = sql;
        return this.realStatement.executeUpdate(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.logAll("executeUpdate", sql);
        DBUtil.checkReadOnly(sql, this.readOnly);
        this.sql = sql;
        return this.realStatement.executeUpdate(sql, columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.logAll("executeUpdate", sql);
        DBUtil.checkReadOnly(sql, this.readOnly);
        this.sql = sql;
        return this.realStatement.executeUpdate(sql, columnNames);
    }

    public int executeUpdate(String sql) throws SQLException {
        this.logAll("executeUpdate", sql);
        DBUtil.checkReadOnly(sql, this.readOnly);
        this.sql = sql;
        return this.realStatement.executeUpdate(sql);
    }

    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        jdbcLogger.debug("close: " + this.sql);
        this.closed = true;
        openStatementCount.decrementAndGet();
        if (openStatementMonitor != null) {
            openStatementMonitor.unregister((Object)this);
        }
        this.realStatement.close();
    }

    public static int getOpenStatementCount() {
        return openStatementCount.get();
    }

    public static void resetMonitors() {
        openStatementCount.set(0);
        if (openStatementMonitor != null) {
            openStatementMonitor.reset();
        }
    }

    public static boolean assertAllStatementsClosed(boolean critical) {
        return openStatementMonitor.assertNoRegistrations(critical);
    }

    private void logAll(String method, String sql) {
        if (jdbcLogger.isDebugEnabled()) {
            jdbcLogger.debug(method + ": " + sql);
        }
        sqlLogger.debug(sql);
    }

    public String toString() {
        return "Statement (" + this.sql + ")";
    }

    static {
        if (Debug.active()) {
            openStatementMonitor = new ResourceMonitor();
        }
    }
}

