/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.util.StringUtils;

public class FetchGroupMetaData
extends MetaData {
    Boolean postLoad;
    final String name;
    protected FetchGroupMetaData[] fetchGroupMetaData;
    protected AbstractMemberMetaData[] memberMetaData;
    protected List<FetchGroupMetaData> fetchGroups = new ArrayList<FetchGroupMetaData>();
    protected List<AbstractMemberMetaData> members = new ArrayList<AbstractMemberMetaData>();

    public FetchGroupMetaData(String name) {
        this.name = name;
    }

    public void initialise(ClassLoaderResolver clr) {
        int i;
        if (this.postLoad == null) {
            this.postLoad = Boolean.FALSE;
        }
        if (this.members.isEmpty()) {
            this.memberMetaData = new AbstractMemberMetaData[0];
        } else {
            this.memberMetaData = new AbstractMemberMetaData[this.members.size()];
            for (i = 0; i < this.memberMetaData.length; ++i) {
                this.memberMetaData[i] = this.members.get(i);
            }
        }
        if (this.fetchGroups.isEmpty()) {
            this.fetchGroupMetaData = new FetchGroupMetaData[0];
        } else {
            this.fetchGroupMetaData = new FetchGroupMetaData[this.fetchGroups.size()];
            for (i = 0; i < this.fetchGroupMetaData.length; ++i) {
                this.fetchGroupMetaData[i] = this.fetchGroups.get(i);
            }
        }
        for (i = 0; i < this.fetchGroupMetaData.length; ++i) {
            this.fetchGroupMetaData[i].initialise(clr);
        }
        super.initialise(clr);
        this.fetchGroups.clear();
        this.fetchGroups = null;
        this.members.clear();
        this.members = null;
    }

    public final String getName() {
        return this.name;
    }

    public final Boolean getPostLoad() {
        return this.postLoad;
    }

    public FetchGroupMetaData setPostLoad(Boolean postLoad) {
        this.postLoad = postLoad;
        return this;
    }

    public FetchGroupMetaData setPostLoad(String postLoad) {
        if (!StringUtils.isWhitespace(postLoad)) {
            if (postLoad.equalsIgnoreCase("true")) {
                this.postLoad = Boolean.TRUE;
            } else if (postLoad.equalsIgnoreCase("false")) {
                this.postLoad = Boolean.FALSE;
            }
        }
        return this;
    }

    public final FetchGroupMetaData[] getFetchGroupMetaData() {
        return this.fetchGroupMetaData;
    }

    public final AbstractMemberMetaData[] getMemberMetaData() {
        return this.memberMetaData;
    }

    public int getNumberOfMembers() {
        return this.members.size();
    }

    public void addFetchGroup(FetchGroupMetaData fgmd) {
        this.fetchGroups.add(fgmd);
        fgmd.parent = this;
    }

    public void addMember(AbstractMemberMetaData mmd) {
        this.members.add(mmd);
        mmd.parent = this;
    }

    public FieldMetaData newFieldMetaData(String name) {
        FieldMetaData fmd = new FieldMetaData((MetaData)this, name);
        this.addMember(fmd);
        return fmd;
    }

    public PropertyMetaData newPropertyMetaData(String name) {
        PropertyMetaData pmd = new PropertyMetaData((MetaData)this, name);
        this.addMember(pmd);
        return pmd;
    }

    public String toString(String prefix, String indent) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<fetch-group name=\"" + this.name + "\"\n");
        if (this.fetchGroupMetaData != null) {
            for (i = 0; i < this.fetchGroupMetaData.length; ++i) {
                sb.append(this.fetchGroupMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.memberMetaData != null) {
            for (i = 0; i < this.memberMetaData.length; ++i) {
                sb.append(this.memberMetaData[i].toString(prefix + indent, indent));
            }
        }
        sb.append(prefix + "</fetch-group>\n");
        return sb.toString();
    }
}

