/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.BooleanLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

public class CollectionLiteral
extends ScalarExpression {
    private final boolean isEmpty;
    private final boolean containsNull;
    private List scalarExpressions;

    public CollectionLiteral(QueryExpression qs, JavaTypeMapping mapping, Collection value) {
        super(qs);
        this.mapping = mapping;
        this.containsNull = value != null && value.contains(null);
        boolean bl = this.isEmpty = value == null || value.isEmpty() || value.size() == 1 && this.containsNull;
        if (!this.isEmpty) {
            this.scalarExpressions = new ArrayList();
            this.st.append("(");
            boolean hadPrev = false;
            for (Object current : value) {
                if (current == null) continue;
                JavaTypeMapping m = qs.getStoreManager().getMappingManager().getMappingWithDatastoreMapping(current.getClass(), false, false, qs.getClassLoaderResolver());
                ScalarExpression expr = m.newLiteral(qs, current);
                this.st.append(hadPrev ? "," : "");
                this.st.append(expr);
                this.scalarExpressions.add(expr);
                hadPrev = true;
            }
            this.st.append(")");
        }
    }

    public BooleanExpression containsMethod(ScalarExpression expr) {
        if (this.isEmpty) {
            return new BooleanLiteral(this.qs, this.mapping, false);
        }
        ScalarExpression bExpr = null;
        for (int i = 0; i < this.scalarExpressions.size(); ++i) {
            bExpr = bExpr == null ? ((ScalarExpression)this.scalarExpressions.get(i)).eq(expr) : ((BooleanExpression)bExpr).ior(((ScalarExpression)this.scalarExpressions.get(i)).eq(expr));
        }
        bExpr.encloseWithInParentheses();
        return bExpr;
    }

    public BooleanExpression isEmptyMethod() {
        return new BooleanLiteral(this.qs, this.mapping, this.isEmpty);
    }
}

