/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jdo;

import javax.jdo.JDOUserException;
import javax.jdo.datastore.JDOConnection;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.jdo.NucleusJDOHelper;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.util.Localiser;

public class JDOConnectionImpl
implements JDOConnection {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.jdo.Localisation", JDOPersistenceManagerFactory.class.getClassLoader());
    protected NucleusConnection nucConn = null;

    public JDOConnectionImpl(NucleusConnection nconn) {
        this.nucConn = nconn;
    }

    public void close() {
        try {
            this.nucConn.close();
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public Object getNativeConnection() {
        try {
            return this.nucConn.getNativeConnection();
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    protected void throwExceptionNotAvailable() {
        throw new JDOUserException(LOCALISER.msg("046001"));
    }

    protected void throwExceptionUnsupportedOperation(String methodName) {
        throw new JDOUserException(LOCALISER.msg("046000", (Object)methodName));
    }
}

