/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.util.Localiser;

public abstract class JavaTypeMapping {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected AbstractMemberMetaData mmd;
    protected int roleForMember = 0;
    protected DatastoreMapping[] datastoreMappings = new DatastoreMapping[0];
    protected DatastoreContainerObject datastoreContainer;
    protected MappedStoreManager storeMgr;
    protected String type;
    protected JavaTypeMapping referenceMapping;

    protected JavaTypeMapping() {
    }

    public void initialize(MappedStoreManager storeMgr, String type) {
        this.storeMgr = storeMgr;
        this.type = type;
    }

    public void initialize(AbstractMemberMetaData mmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        this.storeMgr = container.getStoreManager();
        this.mmd = mmd;
        this.datastoreContainer = container;
        this.type = this.roleForMember == 4 ? mmd.getArray().getElementType() : (this.roleForMember == 3 ? mmd.getCollection().getElementType() : (this.roleForMember == 5 ? mmd.getMap().getKeyType() : (this.roleForMember == 6 ? mmd.getMap().getValueType() : mmd.getType().getName())));
    }

    public int hashCode() {
        return this.mmd == null || this.datastoreContainer == null ? super.hashCode() : this.mmd.hashCode() ^ this.datastoreContainer.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        AbstractContainerMapping other = (AbstractContainerMapping)obj;
        return this.mmd.equals(other.mmd) && this.datastoreContainer.equals(other.datastoreContainer);
    }

    public void setMemberMetaData(AbstractMemberMetaData mmd) {
        this.mmd = mmd;
    }

    public void setDatastoreContainer(DatastoreContainerObject table) {
        this.datastoreContainer = table;
    }

    public void setRoleForMember(int role) {
        this.roleForMember = role;
    }

    public AbstractMemberMetaData getMemberMetaData() {
        return this.mmd;
    }

    public int getRoleForMember() {
        return this.roleForMember;
    }

    public boolean isSerialised() {
        if (this.roleForMember == 3) {
            if (this.mmd == null) {
                return false;
            }
            return this.mmd.getCollection() != null ? this.mmd.getCollection().isSerializedElement() : false;
        }
        if (this.roleForMember == 4) {
            if (this.mmd == null) {
                return false;
            }
            return this.mmd.getArray() != null ? this.mmd.getArray().isSerializedElement() : false;
        }
        if (this.roleForMember == 5) {
            if (this.mmd == null) {
                return false;
            }
            return this.mmd.getMap() != null ? this.mmd.getMap().isSerializedKey() : false;
        }
        if (this.roleForMember == 6) {
            if (this.mmd == null) {
                return false;
            }
            return this.mmd.getMap() != null ? this.mmd.getMap().isSerializedValue() : false;
        }
        return this.mmd != null ? this.mmd.isSerialized() : false;
    }

    public boolean isNullable() {
        for (int i = 0; i < this.datastoreMappings.length; ++i) {
            if (this.datastoreMappings[i].isNullable()) continue;
            return false;
        }
        return true;
    }

    public boolean hasSimpleDatastoreRepresentation() {
        return true;
    }

    public DatastoreMapping[] getDatastoreMappings() {
        return this.datastoreMappings;
    }

    public DatastoreContainerObject getDatastoreContainer() {
        return this.datastoreContainer;
    }

    public DatastoreMapping getDatastoreMapping(int index) {
        return this.datastoreMappings[index];
    }

    public Object getValueForDatastoreMapping(OMFContext omfCtx, int index, Object value) {
        return value;
    }

    public JavaTypeMapping getReferenceMapping() {
        return this.referenceMapping;
    }

    public void setReferenceMapping(JavaTypeMapping referenceMapping) {
        this.referenceMapping = referenceMapping;
    }

    public void addDatastoreMapping(DatastoreMapping datastoreMapping) {
        DatastoreMapping[] dm = this.datastoreMappings;
        this.datastoreMappings = new DatastoreMapping[this.datastoreMappings.length + 1];
        System.arraycopy(dm, 0, this.datastoreMappings, 0, dm.length);
        this.datastoreMappings[dm.length] = datastoreMapping;
    }

    public int getNumberOfDatastoreMappings() {
        return this.datastoreMappings.length;
    }

    public abstract Class getJavaType();

    public String getJavaTypeForDatastoreMapping(int index) {
        throw new UnsupportedOperationException("Datastore type mapping is not supported by: " + this.getClass());
    }

    public String getType() {
        return this.type;
    }

    public boolean includeInFetchStatement() {
        return true;
    }

    public boolean includeInUpdateStatement() {
        return true;
    }

    public boolean includeInInsertStatement() {
        return true;
    }

    protected String failureMessage(String method) {
        return LOCALISER.msg("041004", (Object)this.getClass().getName(), (Object)method);
    }

    public void setBoolean(ExecutionContext ec, Object datastoreStatement, int[] exprIndex, boolean value) {
        throw new NucleusException(this.failureMessage("setBoolean")).setFatal();
    }

    public boolean getBoolean(ExecutionContext ec, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("setBoolean")).setFatal();
    }

    public void setChar(ExecutionContext ec, Object datastoreStatement, int[] exprIndex, char value) {
        throw new NucleusException(this.failureMessage("setChar")).setFatal();
    }

    public char getChar(ExecutionContext ec, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getChar")).setFatal();
    }

    public void setByte(ExecutionContext ec, Object datastoreStatement, int[] exprIndex, byte value) {
        throw new NucleusException(this.failureMessage("setByte")).setFatal();
    }

    public byte getByte(ExecutionContext ec, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getByte")).setFatal();
    }

    public void setShort(ExecutionContext ec, Object datastoreStatement, int[] exprIndex, short value) {
        throw new NucleusException(this.failureMessage("setShort")).setFatal();
    }

    public short getShort(ExecutionContext ec, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getShort")).setFatal();
    }

    public void setInt(ExecutionContext ec, Object datastoreStatement, int[] exprIndex, int value) {
        throw new NucleusException(this.failureMessage("setInt")).setFatal();
    }

    public int getInt(ExecutionContext ec, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getInt")).setFatal();
    }

    public void setLong(ExecutionContext ec, Object datastoreStatement, int[] exprIndex, long value) {
        throw new NucleusException(this.failureMessage("setLong")).setFatal();
    }

    public long getLong(ExecutionContext ec, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getLong")).setFatal();
    }

    public void setFloat(ExecutionContext ec, Object datastoreStatement, int[] exprIndex, float value) {
        throw new NucleusException(this.failureMessage("setFloat")).setFatal();
    }

    public float getFloat(ExecutionContext ec, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getFloat")).setFatal();
    }

    public void setDouble(ExecutionContext ec, Object datastoreStatement, int[] exprIndex, double value) {
        throw new NucleusException(this.failureMessage("setDouble")).setFatal();
    }

    public double getDouble(ExecutionContext ec, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getDouble")).setFatal();
    }

    public void setString(ExecutionContext ec, Object datastoreStatement, int[] exprIndex, String value) {
        throw new NucleusException(this.failureMessage("setString")).setFatal();
    }

    public String getString(ExecutionContext ec, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getString")).setFatal();
    }

    public void setObject(ExecutionContext ec, Object datastoreStatement, int[] exprIndex, Object value, ObjectProvider ownerSM, int ownerFieldNumber) {
        throw new NucleusException(this.failureMessage("setObject")).setFatal();
    }

    public void setObject(ExecutionContext ec, Object datastoreStatement, int[] exprIndex, Object value) {
        throw new NucleusException(this.failureMessage("setObject")).setFatal();
    }

    public Object getObject(ExecutionContext ec, Object datastoreResults, int[] exprIndex, ObjectProvider ownerSM, int ownerFieldNumber) {
        throw new NucleusException(this.failureMessage("getObject")).setFatal();
    }

    public Object getObject(ExecutionContext ec, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getObject")).setFatal();
    }

    protected static ColumnMetaData[] getColumnMetaDataForMember(AbstractMemberMetaData mmd, int role) {
        if (mmd == null) {
            return null;
        }
        ColumnMetaData[] colmds = null;
        if (role == 3 || role == 4) {
            if (mmd.getJoinMetaData() != null && mmd.getElementMetaData() != null && mmd.getElementMetaData().getColumnMetaData() != null) {
                colmds = mmd.getElementMetaData().getColumnMetaData();
            }
        } else if (role == 5) {
            if (mmd.getJoinMetaData() != null && mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getColumnMetaData() != null) {
                colmds = mmd.getKeyMetaData().getColumnMetaData();
            }
        } else if (role == 6) {
            if (mmd.getJoinMetaData() != null && mmd.getValueMetaData() != null && mmd.getValueMetaData().getColumnMetaData() != null) {
                colmds = mmd.getValueMetaData().getColumnMetaData();
            }
        } else if (mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
            colmds = mmd.getColumnMetaData();
        }
        return colmds;
    }
}

