/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchPlanForClass;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.util.ConcurrentReferenceHashMap;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class FetchPlan
implements Serializable {
    private static final long serialVersionUID = 6031608568703439025L;
    public static final String DEFAULT = "default";
    public static final String ALL = "all";
    public static final String NONE = "none";
    public static final int DETACH_UNLOAD_FIELDS = 2;
    public static final int DETACH_LOAD_FIELDS = 1;
    public static final int FETCH_SIZE_GREEDY = -1;
    public static final int FETCH_SIZE_OPTIMAL = 0;
    final transient ExecutionContext ec;
    final transient ClassLoaderResolver clr;
    final Set<String> groups = new HashSet<String>();
    transient Set<FetchGroup> dynamicGroups = null;
    int fetchSize = 0;
    int detachmentOptions = 1;
    final transient Map<String, FetchPlanForClass> managedClass = new HashMap<String, FetchPlanForClass>();
    int maxFetchDepth = 1;
    Class[] detachmentRootClasses = null;
    Collection detachmentRoots = null;
    private transient Map<AbstractClassMetaData, Map<BitSet, Boolean>> isToCallPostLoadFetchPlanByCmd;

    public FetchPlan(ExecutionContext ec, ClassLoaderResolver clr) {
        this.ec = ec;
        this.clr = clr;
        this.groups.add(DEFAULT);
        String flds = ec.getNucleusContext().getConfiguration().getStringProperty("datanucleus.detachmentFields");
        if (flds != null) {
            if (flds.equals("load-unload-fields")) {
                this.detachmentOptions = 3;
            } else if (flds.equalsIgnoreCase("unload-fields")) {
                this.detachmentOptions = 2;
            } else if (flds.equalsIgnoreCase("load-fields")) {
                this.detachmentOptions = 1;
            }
        }
    }

    private void markDirty() {
        Iterator<FetchPlanForClass> it = this.managedClass.values().iterator();
        while (it.hasNext()) {
            it.next().markDirty();
        }
    }

    public synchronized FetchPlanForClass getFetchPlanForClass(AbstractClassMetaData cmd) {
        FetchPlanForClass fpClass = this.managedClass.get(cmd.getFullClassName());
        if (fpClass == null) {
            fpClass = new FetchPlanForClass(cmd, this);
            this.managedClass.put(cmd.getFullClassName(), fpClass);
        }
        return fpClass;
    }

    public synchronized FetchPlan addGroup(String grpName) {
        if (grpName != null) {
            boolean changed = this.groups.add(grpName);
            boolean dynChanged = this.addDynamicGroup(grpName);
            if (changed || dynChanged) {
                this.markDirty();
            }
        }
        return this;
    }

    public synchronized FetchPlan removeGroup(String grpName) {
        if (grpName != null) {
            boolean changed = false;
            changed = this.groups.remove(grpName);
            if (this.dynamicGroups != null) {
                Iterator<FetchGroup> iter = this.dynamicGroups.iterator();
                while (iter.hasNext()) {
                    FetchGroup grp = iter.next();
                    if (!grp.getName().equals(grpName)) continue;
                    grp.deregisterListener(this);
                    changed = true;
                    iter.remove();
                }
            }
            if (changed) {
                this.markDirty();
            }
        }
        return this;
    }

    public synchronized FetchPlan clearGroups() {
        this.clearDynamicGroups();
        this.groups.clear();
        this.markDirty();
        return this;
    }

    public synchronized Set<String> getGroups() {
        return Collections.unmodifiableSet(new HashSet<String>(this.groups));
    }

    public synchronized FetchPlan setGroups(Collection<String> grpNames) {
        this.clearDynamicGroups();
        this.groups.clear();
        if (grpNames != null) {
            HashSet<String> g = new HashSet<String>(grpNames);
            this.groups.addAll(g);
            Iterator<String> iter = grpNames.iterator();
            while (iter.hasNext()) {
                this.addDynamicGroup(iter.next());
            }
        }
        this.markDirty();
        return this;
    }

    public synchronized FetchPlan setGroups(String[] grpNames) {
        this.clearDynamicGroups();
        this.groups.clear();
        if (grpNames != null) {
            int i;
            for (i = 0; i < grpNames.length; ++i) {
                this.groups.add(grpNames[i]);
            }
            for (i = 0; i < grpNames.length; ++i) {
                this.addDynamicGroup(grpNames[i]);
            }
        }
        this.markDirty();
        return this;
    }

    public synchronized FetchPlan setGroup(String grpName) {
        this.clearDynamicGroups();
        this.groups.clear();
        if (grpName != null) {
            this.groups.add(grpName);
            this.addDynamicGroup(grpName);
        }
        this.markDirty();
        return this;
    }

    private void clearDynamicGroups() {
        if (this.dynamicGroups != null) {
            Iterator<FetchGroup> iter = this.dynamicGroups.iterator();
            while (iter.hasNext()) {
                iter.next().deregisterListener(this);
            }
            this.dynamicGroups.clear();
        }
    }

    private boolean addDynamicGroup(String grpName) {
        Set<FetchGroup> grpsWithName;
        boolean changed = false;
        Set<FetchGroup> ecGrpsWithName = this.ec.getFetchGroupsWithName(grpName);
        if (ecGrpsWithName != null) {
            if (this.dynamicGroups == null) {
                this.dynamicGroups = new HashSet<FetchGroup>();
            }
            for (FetchGroup grp : ecGrpsWithName) {
                this.dynamicGroups.add(grp);
                grp.registerListener(this);
                changed = true;
            }
        }
        if (!changed && (grpsWithName = this.ec.getNucleusContext().getFetchGroupsWithName(grpName)) != null) {
            if (this.dynamicGroups == null) {
                this.dynamicGroups = new HashSet<FetchGroup>();
            }
            for (FetchGroup grp : grpsWithName) {
                this.dynamicGroups.add(grp);
                grp.registerListener(this);
                changed = true;
            }
        }
        return changed;
    }

    public void notifyFetchGroupChange(FetchGroup group) {
        Collection<FetchPlanForClass> fpClasses = this.managedClass.values();
        for (FetchPlanForClass fpClass : fpClasses) {
            Class cls = this.clr.classForName(fpClass.cmd.getFullClassName());
            if (!cls.isAssignableFrom(group.getType()) && !group.getType().isAssignableFrom(cls)) continue;
            fpClass.markDirty();
        }
    }

    public void notifyFetchGroupRemove(FetchGroup group) {
        this.dynamicGroups.remove(group);
        this.notifyFetchGroupChange(group);
    }

    public FetchPlan setDetachmentRoots(Collection roots) {
        if (this.detachmentRootClasses != null || this.detachmentRoots != null) {
            throw new NucleusUserException(Localiser.msg("006003"));
        }
        if (roots == null) {
            this.detachmentRoots = null;
        }
        this.detachmentRoots = new ArrayList();
        this.detachmentRoots.addAll(roots);
        return this;
    }

    public Collection<Object> getDetachmentRoots() {
        if (this.detachmentRoots == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.detachmentRoots);
    }

    public FetchPlan setDetachmentRootClasses(Class[] rootClasses) {
        if (this.detachmentRootClasses != null || this.detachmentRoots != null) {
            throw new NucleusUserException(Localiser.msg("006003"));
        }
        if (rootClasses == null) {
            this.detachmentRootClasses = null;
            return this;
        }
        this.detachmentRootClasses = new Class[rootClasses.length];
        for (int i = 0; i < rootClasses.length; ++i) {
            this.detachmentRootClasses[i] = rootClasses[i];
        }
        return this;
    }

    public Class[] getDetachmentRootClasses() {
        if (this.detachmentRootClasses == null) {
            return new Class[0];
        }
        return this.detachmentRootClasses;
    }

    void resetDetachmentRoots() {
        this.detachmentRootClasses = null;
        this.detachmentRoots = null;
    }

    public synchronized FetchPlan setMaxFetchDepth(int max) {
        if (max == 0) {
            throw new NucleusUserException(Localiser.msg("006002", max));
        }
        this.maxFetchDepth = max;
        return this;
    }

    public synchronized int getMaxFetchDepth() {
        return this.maxFetchDepth;
    }

    public synchronized FetchPlan setFetchSize(int fetchSize) {
        if (fetchSize != -1 && fetchSize != 0 && fetchSize < 0) {
            return this;
        }
        this.fetchSize = fetchSize;
        return this;
    }

    public synchronized int getFetchSize() {
        return this.fetchSize;
    }

    public int getDetachmentOptions() {
        return this.detachmentOptions;
    }

    public FetchPlan setDetachmentOptions(int options) {
        this.detachmentOptions = options;
        return this;
    }

    public synchronized FetchPlan getCopy() {
        FetchPlan fp = new FetchPlan(this.ec, this.clr);
        fp.maxFetchDepth = this.maxFetchDepth;
        fp.groups.remove(DEFAULT);
        fp.groups.addAll(this.groups);
        if (this.dynamicGroups != null) {
            fp.dynamicGroups = new HashSet<FetchGroup>(this.dynamicGroups);
        }
        for (Map.Entry<String, FetchPlanForClass> entry : this.managedClass.entrySet()) {
            String className = entry.getKey();
            FetchPlanForClass fpcls = entry.getValue();
            fp.managedClass.put(className, fpcls.getCopy(fp));
        }
        fp.fetchSize = this.fetchSize;
        return fp;
    }

    Boolean getCachedIsToCallPostLoadFetchPlan(AbstractClassMetaData cmd, BitSet loadedFields) {
        Map<BitSet, Boolean> cachedIsToCallPostLoadFetchPlan;
        if (this.isToCallPostLoadFetchPlanByCmd == null) {
            this.isToCallPostLoadFetchPlanByCmd = new ConcurrentReferenceHashMap<AbstractClassMetaData, Map<BitSet, Boolean>>(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.SOFT);
        }
        if ((cachedIsToCallPostLoadFetchPlan = this.isToCallPostLoadFetchPlanByCmd.get(cmd)) == null) {
            return null;
        }
        return cachedIsToCallPostLoadFetchPlan.get(loadedFields);
    }

    void cacheIsToCallPostLoadFetchPlan(AbstractClassMetaData cmd, BitSet loadedFields, Boolean itcplfp) {
        Map<BitSet, Boolean> cachedIsToCallPostLoadFetchPlan;
        if (this.isToCallPostLoadFetchPlanByCmd == null) {
            this.isToCallPostLoadFetchPlanByCmd = new ConcurrentReferenceHashMap<AbstractClassMetaData, Map<BitSet, Boolean>>(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.SOFT);
        }
        if ((cachedIsToCallPostLoadFetchPlan = this.isToCallPostLoadFetchPlanByCmd.get(cmd)) == null) {
            cachedIsToCallPostLoadFetchPlan = new ConcurrentReferenceHashMap<BitSet, Boolean>(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.SOFT);
            this.isToCallPostLoadFetchPlanByCmd.put(cmd, cachedIsToCallPostLoadFetchPlan);
        }
        cachedIsToCallPostLoadFetchPlan.put(loadedFields, itcplfp);
    }

    void invalidateCachedIsToCallPostLoadFetchPlan(AbstractClassMetaData cmd) {
        Map<BitSet, Boolean> cachedIsToCallPostLoadFetchPlan;
        if (this.isToCallPostLoadFetchPlanByCmd == null) {
            this.isToCallPostLoadFetchPlanByCmd = new ConcurrentReferenceHashMap<AbstractClassMetaData, Map<BitSet, Boolean>>(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.SOFT);
        }
        if ((cachedIsToCallPostLoadFetchPlan = this.isToCallPostLoadFetchPlanByCmd.get(cmd)) != null) {
            cachedIsToCallPostLoadFetchPlan.clear();
        }
    }

    public String toStringWithClasses() {
        return "FetchPlan " + this.groups.toString() + " classes=" + StringUtils.collectionToString(Collections.unmodifiableCollection(this.managedClass.values()));
    }

    public String toString() {
        return "FetchPlan " + this.groups.toString();
    }
}

