/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.NullifyRelationFieldManager;
import org.datanucleus.store.fieldmanager.ReachabilityFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ReachabilityAtCommitHandler {
    private ExecutionContext ec;
    private boolean executing = false;
    private Set persistedIds = null;
    private Set deletedIds = null;
    private Set flushedNewIds = null;
    private Set enlistedIds = null;

    public ReachabilityAtCommitHandler(ExecutionContext ec) {
        this.ec = ec;
        this.persistedIds = ec.getMultithreaded() ? ConcurrentHashMap.newKeySet() : new HashSet();
        this.deletedIds = ec.getMultithreaded() ? ConcurrentHashMap.newKeySet() : new HashSet();
        this.flushedNewIds = ec.getMultithreaded() ? ConcurrentHashMap.newKeySet() : new HashSet();
        this.enlistedIds = ec.getMultithreaded() ? ConcurrentHashMap.newKeySet() : new HashSet();
    }

    public void clear() {
        this.persistedIds.clear();
        this.deletedIds.clear();
        this.flushedNewIds.clear();
        this.enlistedIds.clear();
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void addEnlistedObject(Object id) {
        this.enlistedIds.add(id);
    }

    public boolean isObjectEnlisted(Object id) {
        return this.enlistedIds.contains(id);
    }

    public void addPersistedObject(Object id) {
        this.persistedIds.add(id);
    }

    public boolean isObjectPersisted(Object id) {
        return this.persistedIds.contains(id);
    }

    public void addDeletedObject(Object id) {
        this.deletedIds.add(id);
    }

    public boolean isObjectDeleted(Object id) {
        return this.deletedIds.contains(id);
    }

    public void addFlushedNewObject(Object id) {
        this.flushedNewIds.add(id);
    }

    public boolean isObjectFlushedNew(Object id) {
        return this.flushedNewIds.contains(id);
    }

    public void swapObjectId(Object oldID, Object newID) {
        if (oldID != null) {
            if (this.enlistedIds.remove(oldID)) {
                this.enlistedIds.add(newID);
            }
            if (this.flushedNewIds.remove(oldID)) {
                this.flushedNewIds.add(newID);
            }
            if (this.persistedIds.remove(oldID)) {
                this.persistedIds.add(newID);
            }
            if (this.deletedIds.remove(oldID)) {
                this.deletedIds.add(newID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            this.executing = true;
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("010032"));
            }
            if (!this.persistedIds.isEmpty() && !this.flushedNewIds.isEmpty()) {
                HashSet<Object> currentReachables = new HashSet<Object>();
                Object[] ids = this.persistedIds.toArray();
                HashSet<Object> objectNotFound = new HashSet<Object>();
                for (int i = 0; i < ids.length; ++i) {
                    if (this.deletedIds.contains(ids[i])) continue;
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug("Performing reachability algorithm on object with id \"" + ids[i] + "\"");
                    }
                    try {
                        ObjectProvider op = this.ec.findObjectProvider(this.ec.findObject(ids[i], true, true, null));
                        if (op.isDeleted() || currentReachables.contains(ids[i])) continue;
                        op.loadUnloadedRelationFields();
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug(Localiser.msg("007000", StringUtils.toJVMIDString(op.getObject()), ids[i], op.getLifecycleState()));
                        }
                        currentReachables.add(ids[i]);
                        ReachabilityFieldManager pcFM = new ReachabilityFieldManager(op, currentReachables);
                        int[] relationFieldNums = op.getClassMetaData().getRelationMemberPositions(this.ec.getClassLoaderResolver());
                        if (relationFieldNums == null || relationFieldNums.length <= 0) continue;
                        op.provideFields(relationFieldNums, pcFM);
                        continue;
                    }
                    catch (NucleusObjectNotFoundException ex) {
                        objectNotFound.add(ids[i]);
                    }
                }
                this.flushedNewIds.removeAll(currentReachables);
                Object[] nonReachableIds = this.flushedNewIds.toArray();
                if (nonReachableIds != null && nonReachableIds.length > 0) {
                    ObjectProvider op2;
                    int i;
                    for (i = 0; i < nonReachableIds.length; ++i) {
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug(Localiser.msg("010033", nonReachableIds[i]));
                        }
                        try {
                            if (objectNotFound.contains(nonReachableIds[i]) || (op2 = this.ec.findObjectProvider(this.ec.findObject(nonReachableIds[i], true, true, null))).getLifecycleState().isDeleted() || this.ec.getApiAdapter().isDetached(op2.getObject())) continue;
                            op2.replaceFields(op2.getClassMetaData().getNonPKMemberPositions(), new NullifyRelationFieldManager(op2));
                            this.ec.flush();
                            continue;
                        }
                        catch (NucleusObjectNotFoundException op2) {
                            // empty catch block
                        }
                    }
                    for (i = 0; i < nonReachableIds.length; ++i) {
                        try {
                            if (objectNotFound.contains(nonReachableIds[i])) continue;
                            op2 = this.ec.findObjectProvider(this.ec.findObject(nonReachableIds[i], true, true, null));
                            op2.deletePersistent();
                            continue;
                        }
                        catch (NucleusObjectNotFoundException nucleusObjectNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                this.ec.flushInternal(true);
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("010034"));
            }
        }
        finally {
            this.executing = false;
        }
    }
}

