/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.containers;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.store.types.ContainerHandler;
import org.datanucleus.store.types.MapContainerAdapter;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public abstract class MapHandler<C>
implements ContainerHandler<C, MapContainerAdapter<C>> {
    @Override
    public MapMetaData newMetaData() {
        return new MapMetaData();
    }

    @Override
    public void populateMetaData(ClassLoaderResolver clr, ClassLoader primary, AbstractMemberMetaData mmd) {
        MapMetaData mapMd = this.assertValidType(mmd.getContainer());
        if (mapMd.getKeyType() == null) {
            mapMd.setKeyType(this.getKeyType(mmd));
        }
        if (mapMd.getValueType() == null) {
            mapMd.setValueType(this.getValueType(mmd));
        }
        this.moveColumnsToValue(mmd);
        if (mmd.getKeyMetaData() != null) {
            mmd.getKeyMetaData().populate(clr, primary);
        }
        if (mmd.getValueMetaData() != null) {
            mmd.getValueMetaData().populate(clr, primary);
        }
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            String keyCascadeVal = mmd.getValueForExtension("cascade-delete-key");
            if (mmd.isCascadeDelete()) {
                mapMd.setDependentKey(false);
                mapMd.setDependentValue(true);
            }
            if (keyCascadeVal != null) {
                if (keyCascadeVal.equalsIgnoreCase("true")) {
                    mapMd.setDependentKey(true);
                } else {
                    mapMd.setDependentKey(false);
                }
            }
            mapMd.populate(clr, primary);
        }
    }

    private String getKeyType(AbstractMemberMetaData mmd) {
        String keyType = null;
        Member member = mmd.getMemberRepresented();
        if (member instanceof Field) {
            keyType = ClassUtils.getMapKeyType((Field)member);
        } else if (member instanceof Method) {
            keyType = ClassUtils.getMapKeyType((Method)member);
        }
        if (keyType == null) {
            ParameterizedType paramGenType;
            Type keyGenericType;
            Type genericType;
            Type type = genericType = member instanceof Field ? ((Field)member).getGenericType() : ((Method)member).getGenericReturnType();
            if (genericType != null && genericType instanceof ParameterizedType && (keyGenericType = (paramGenType = (ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof TypeVariable) {
                ParameterizedType paramKeyGenType;
                Type paramKeyGenTypeRaw;
                Type keyGenTypeBound = ((TypeVariable)keyGenericType).getBounds()[0];
                if (keyGenTypeBound instanceof Class) {
                    keyType = ((Class)keyGenTypeBound).getName();
                } else if (keyGenTypeBound instanceof ParameterizedType && (paramKeyGenTypeRaw = (paramKeyGenType = (ParameterizedType)keyGenTypeBound).getRawType()) != null && paramKeyGenTypeRaw instanceof Class) {
                    keyType = ((Class)paramKeyGenTypeRaw).getName();
                }
            }
        }
        if (keyType == null) {
            keyType = Object.class.getName();
            NucleusLogger.METADATA.debug(Localiser.msg("044004", mmd.getClassName(), mmd.getName()));
        }
        return keyType;
    }

    private String getValueType(AbstractMemberMetaData mmd) {
        String valueType = null;
        if (mmd.getTargetClassName() == null) {
            Member member = mmd.getMemberRepresented();
            valueType = member instanceof Field ? ClassUtils.getMapValueType((Field)member) : ClassUtils.getMapValueType((Method)member);
            if (valueType == null) {
                ParameterizedType paramGenType;
                Type valueGenericType;
                Type genericType;
                Type type = genericType = member instanceof Field ? ((Field)member).getGenericType() : ((Method)member).getGenericReturnType();
                if (genericType != null && genericType instanceof ParameterizedType && (valueGenericType = (paramGenType = (ParameterizedType)genericType).getActualTypeArguments()[1]) instanceof TypeVariable) {
                    ParameterizedType paramValGenType;
                    Type paramValGenTypeRaw;
                    Type valueGenTypeBound = ((TypeVariable)valueGenericType).getBounds()[0];
                    if (valueGenTypeBound instanceof Class) {
                        valueType = ((Class)valueGenTypeBound).getName();
                    } else if (valueGenTypeBound instanceof ParameterizedType && (paramValGenTypeRaw = (paramValGenType = (ParameterizedType)valueGenTypeBound).getRawType()) != null && paramValGenTypeRaw instanceof Class) {
                        valueType = ((Class)paramValGenTypeRaw).getName();
                    }
                }
            }
        } else {
            valueType = mmd.getTargetClassName();
        }
        if (valueType == null) {
            valueType = Object.class.getName();
            NucleusLogger.METADATA.debug(Localiser.msg("044004", mmd.getClassName(), mmd.getName()));
        }
        return valueType;
    }

    private MapMetaData assertValidType(ContainerMetaData metaData) {
        if (metaData instanceof MapMetaData) {
            return (MapMetaData)metaData;
        }
        throw new NucleusException("Invalid type of metadata specified.");
    }

    private void moveColumnsToValue(AbstractMemberMetaData mmd) {
        ColumnMetaData[] columnMetaData = mmd.getColumnMetaData();
        if (!mmd.isSerialized() && !mmd.isEmbedded() && columnMetaData != null && mmd.getTypeConverterName() == null && mmd.getValueMetaData() == null) {
            ValueMetaData valmd = new ValueMetaData();
            mmd.setValueMetaData(valmd);
            for (int i = 0; i < columnMetaData.length; ++i) {
                valmd.addColumn(columnMetaData[i]);
            }
            mmd.clearColumns();
        }
    }

    @Override
    public boolean isSerialised(AbstractMemberMetaData mmd) {
        return mmd.isSerialized() || mmd.getMap().isSerializedKey() || mmd.getMap().isSerializedValue();
    }

    @Override
    public boolean isEmbedded(AbstractMemberMetaData mmd) {
        return mmd.isEmbedded() || mmd.getMap().isEmbeddedKey() || mmd.getMap().isEmbeddedValue();
    }

    @Override
    public boolean isDefaultFetchGroup(ClassLoaderResolver clr, TypeManager typeMgr, AbstractMemberMetaData mmd) {
        return false;
    }
}

