/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.datanucleus.identity.SingleFieldId;

public class LongId
extends SingleFieldId<Long, LongId> {
    private long key;

    public LongId(Class<?> pcClass, long key) {
        super(pcClass);
        this.key = key;
        this.hashCode = this.targetClassName.hashCode() ^ (int)key;
    }

    public LongId(Class<?> pcClass, Long key) {
        this(pcClass, key != null ? key : -1L);
        this.assertKeyNotNull(key);
    }

    public LongId(Class<?> pcClass, String str) {
        this(pcClass, Long.parseLong(str));
        this.assertKeyNotNull(str);
    }

    public LongId() {
    }

    public long getKey() {
        return this.key;
    }

    @Override
    public Long getKeyAsObject() {
        return this.key;
    }

    public String toString() {
        return Long.toString(this.key);
    }

    @Override
    protected boolean keyEquals(LongId obj) {
        return this.key == obj.key;
    }

    @Override
    public int compareTo(LongId other) {
        int result = super.compare(other);
        if (result == 0) {
            long diff = this.key - other.key;
            if (diff == 0L) {
                return 0;
            }
            if (diff < 0L) {
                return -1;
            }
            return 1;
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.key);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.key = in.readLong();
    }
}

