/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.StateManagerFactoryImpl;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class StateManagerPool {
    private long maxIdle = 100L;
    private long expirationTime;
    private Map<DNStateManager, Long> recyclableSMs;
    private CleanUpThread cleaner;
    private Class<? extends DNStateManager> smClass;

    public StateManagerPool(int maxIdle, boolean reaperThread, Class<? extends DNStateManager> smClass) {
        this.maxIdle = maxIdle;
        this.expirationTime = 30000L;
        this.recyclableSMs = new ConcurrentHashMap<DNStateManager, Long>();
        this.smClass = smClass;
        if (reaperThread) {
            this.cleaner = new CleanUpThread(this, this.expirationTime * 2L);
            this.cleaner.start();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug("Started pool of StateManagers (maxPool=" + maxIdle + ", reaperThread=" + reaperThread + ")");
        }
    }

    public void close() {
        if (this.cleaner != null) {
            this.cleaner.interrupt();
        }
    }

    protected DNStateManager create(ExecutionContext ec, AbstractClassMetaData cmd) {
        return ClassUtils.newInstance(this.smClass, StateManagerFactoryImpl.STATE_MANAGER_CTR_ARG_CLASSES, new Object[]{ec, cmd});
    }

    public boolean validate(DNStateManager sm) {
        return true;
    }

    public void expire(DNStateManager sm) {
    }

    public synchronized DNStateManager checkOut(ExecutionContext ec, AbstractClassMetaData cmd) {
        DNStateManager sm2;
        long now = System.currentTimeMillis();
        if (!this.recyclableSMs.isEmpty()) {
            Set<DNStateManager> sms = this.recyclableSMs.keySet();
            for (DNStateManager sm2 : sms) {
                if (now - this.recyclableSMs.get(sm2) > this.expirationTime) {
                    this.recyclableSMs.remove(sm2);
                    this.expire(sm2);
                    sm2 = null;
                    continue;
                }
                if (this.validate(sm2)) {
                    this.recyclableSMs.remove(sm2);
                    sm2.connect(ec, cmd);
                    return sm2;
                }
                this.recyclableSMs.remove(sm2);
                this.expire(sm2);
                sm2 = null;
            }
        }
        sm2 = this.create(ec, cmd);
        return sm2;
    }

    public synchronized void cleanUp() {
        long now = System.currentTimeMillis();
        Set<DNStateManager> sms = this.recyclableSMs.keySet();
        for (DNStateManager sm : sms) {
            if (now - this.recyclableSMs.get(sm) <= this.expirationTime) continue;
            this.recyclableSMs.remove(sm);
            this.expire(sm);
            sm = null;
        }
        System.gc();
    }

    public synchronized void checkIn(DNStateManager sm) {
        if ((long)this.recyclableSMs.size() < this.maxIdle) {
            this.recyclableSMs.put(sm, System.currentTimeMillis());
        }
    }

    class CleanUpThread
    extends Thread {
        private StateManagerPool pool;
        private long sleepTime;

        CleanUpThread(StateManagerPool pool, long sleepTime) {
            this.pool = pool;
            this.sleepTime = sleepTime;
        }

        @Override
        public void run() {
            boolean needsStopping = false;
            while (!needsStopping) {
                try {
                    CleanUpThread.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    needsStopping = true;
                }
                this.pool.cleanUp();
            }
        }
    }
}

