/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.datavec.api.util.reflections.DataVecSubTypesScanner;
import org.datavec.api.writable.Writable;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.loader.NativeImageLoader;
import org.datavec.image.transform.ColorConversionTransform;
import org.datavec.image.transform.CropImageTransform;
import org.datavec.image.transform.EqualizeHistTransform;
import org.datavec.image.transform.FilterImageTransform;
import org.datavec.image.transform.FlipImageTransform;
import org.datavec.image.transform.ImageTransform;
import org.datavec.image.transform.RandomCropTransform;
import org.datavec.image.transform.ResizeImageTransform;
import org.datavec.image.transform.RotateImageTransform;
import org.datavec.image.transform.ScaleImageTransform;
import org.datavec.image.transform.WarpImageTransform;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.jackson.annotation.JsonAutoDetect;
import org.nd4j.shade.jackson.annotation.PropertyAccessor;
import org.nd4j.shade.jackson.core.JsonFactory;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.AnnotationIntrospector;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.Module;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.nd4j.shade.jackson.databind.cfg.MapperConfig;
import org.nd4j.shade.jackson.databind.introspect.AnnotatedClass;
import org.nd4j.shade.jackson.databind.jsontype.NamedType;
import org.nd4j.shade.jackson.dataformat.yaml.YAMLFactory;
import org.nd4j.shade.jackson.datatype.joda.JodaModule;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.Store;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageTransformProcess {
    private static final Logger log = LoggerFactory.getLogger(ImageTransformProcess.class);
    private List<ImageTransform> transformList;
    private int seed;
    private static Set<Class<?>> subtypesClassCache = null;
    private static ObjectMapper jsonMapper = ImageTransformProcess.initMapperJson();
    private static ObjectMapper yamlMapper = ImageTransformProcess.initMapperYaml();

    public ImageTransformProcess(int seed, ImageTransform ... transforms) {
        this.seed = seed;
        this.transformList = Arrays.asList(transforms);
    }

    public ImageTransformProcess(int seed, List<ImageTransform> transformList) {
        this.seed = seed;
        this.transformList = transformList;
    }

    public ImageTransformProcess(Builder builder) {
        this(builder.seed, builder.transformList);
    }

    public List<Writable> execute(List<Writable> image) {
        throw new UnsupportedOperationException();
    }

    public INDArray executeArray(ImageWritable image) throws IOException {
        Random random = null;
        if (this.seed != 0) {
            random = new Random(this.seed);
        }
        ImageWritable currentImage = image;
        for (ImageTransform transform : this.transformList) {
            currentImage = transform.transform(currentImage, random);
        }
        NativeImageLoader imageLoader = new NativeImageLoader();
        return imageLoader.asMatrix(currentImage);
    }

    public ImageWritable execute(ImageWritable image) throws IOException {
        Random random = null;
        if (this.seed != 0) {
            random = new Random(this.seed);
        }
        ImageWritable currentImage = image;
        for (ImageTransform transform : this.transformList) {
            currentImage = transform.transform(currentImage, random);
        }
        return currentImage;
    }

    public ImageWritable transformFileUriToInput(URI uri) throws IOException {
        NativeImageLoader imageLoader = new NativeImageLoader();
        ImageWritable img = imageLoader.asWritable(new File(uri));
        return img;
    }

    public String toJson() {
        try {
            return jsonMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jsonProcessingException) {
            jsonMapper = ImageTransformProcess.reinitializeMapperWithSubtypes(jsonMapper);
            try {
                return jsonMapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String toYaml() {
        try {
            return yamlMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jsonProcessingException) {
            yamlMapper = ImageTransformProcess.reinitializeMapperWithSubtypes(yamlMapper);
            try {
                return yamlMapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static ImageTransformProcess fromJson(String json) {
        try {
            return (ImageTransformProcess)jsonMapper.readValue(json, ImageTransformProcess.class);
        }
        catch (IOException iOException) {
            jsonMapper = ImageTransformProcess.reinitializeMapperWithSubtypes(jsonMapper);
            try {
                return (ImageTransformProcess)jsonMapper.readValue(json, ImageTransformProcess.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static ImageTransformProcess fromYaml(String yaml) {
        try {
            return (ImageTransformProcess)yamlMapper.readValue(yaml, ImageTransformProcess.class);
        }
        catch (IOException iOException) {
            yamlMapper = ImageTransformProcess.reinitializeMapperWithSubtypes(yamlMapper);
            try {
                return (ImageTransformProcess)yamlMapper.readValue(yaml, ImageTransformProcess.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static ObjectMapper reinitializeMapperWithSubtypes(ObjectMapper mapper) {
        List<Class> classes = Arrays.asList(ImageTransform.class);
        ArrayList<String> classNames = new ArrayList<String>(6);
        for (Class c : classes) {
            classNames.add(c.getName());
        }
        if (subtypesClassCache == null) {
            List<Class> interfaces = Arrays.asList(ImageTransform.class);
            List<Class> classesList = Arrays.asList(new Class[0]);
            Collection urls = ClasspathHelper.forClassLoader();
            ArrayList<URL> scanUrls = new ArrayList<URL>();
            for (URL u : urls) {
                String path = u.getPath();
                if (path.matches(".*/jre/lib/.*jar")) continue;
                scanUrls.add(u);
            }
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder().exclude("^(?!.*\\.class$).*$").exclude("^org.nd4j.*").exclude("^org.bytedeco.*").exclude("^com.fasterxml.*").exclude("^org.apache.*").exclude("^org.projectlombok.*").exclude("^com.twelvemonkeys.*").exclude("^org.joda.*").exclude("^org.slf4j.*").exclude("^com.google.*").exclude("^org.reflections.*").exclude("^ch.qos.*")).addUrls(scanUrls).setScanners(new Scanner[]{new DataVecSubTypesScanner(interfaces, (List)classesList)}));
            Store store = reflections.getStore();
            Iterable subtypesByName = store.getAll(DataVecSubTypesScanner.class.getSimpleName(), classNames);
            HashSet subtypeClasses = Sets.newHashSet((Iterable)ReflectionUtils.forNames((Iterable)subtypesByName, (ClassLoader[])new ClassLoader[0]));
            subtypesClassCache = new HashSet();
            for (Class c : subtypeClasses) {
                if (Modifier.isAbstract(c.getModifiers()) || Modifier.isInterface(c.getModifiers())) continue;
                subtypesClassCache.add(c);
            }
        }
        HashSet<Class> registeredSubtypes = new HashSet<Class>();
        for (Class c : classes) {
            AnnotatedClass ac = AnnotatedClass.construct((Class)c, (AnnotationIntrospector)mapper.getSerializationConfig().getAnnotationIntrospector(), null);
            Collection types = mapper.getSubtypeResolver().collectAndResolveSubtypes(ac, (MapperConfig)mapper.getSerializationConfig(), mapper.getSerializationConfig().getAnnotationIntrospector());
            for (NamedType nt : types) {
                registeredSubtypes.add(nt.getType());
            }
        }
        ArrayList<NamedType> toRegister = new ArrayList<NamedType>();
        block5: for (Class<?> c : subtypesClassCache) {
            String name;
            if (Modifier.isAbstract(c.getModifiers()) || Modifier.isInterface(c.getModifiers()) || registeredSubtypes.contains(c)) continue;
            if (ClassUtils.isInnerClass(c)) {
                Class<?> c2 = c.getDeclaringClass();
                name = c2.getSimpleName() + "$" + c.getSimpleName();
            } else {
                name = c.getSimpleName();
            }
            toRegister.add(new NamedType(c, name));
            if (!log.isDebugEnabled()) continue;
            for (Class baseClass : classes) {
                if (!baseClass.isAssignableFrom(c)) continue;
                log.debug("Registering class for JSON serialization: {} as subtype of {}", (Object)c.getName(), (Object)baseClass.getName());
                continue block5;
            }
        }
        mapper.registerSubtypes(toRegister.toArray(new NamedType[toRegister.size()]));
        mapper = mapper.copy();
        return mapper;
    }

    private static ObjectMapper initMapperJson() {
        return ImageTransformProcess.initMapper(new JsonFactory());
    }

    private static ObjectMapper initMapperYaml() {
        return ImageTransformProcess.initMapper((JsonFactory)new YAMLFactory());
    }

    private static ObjectMapper initMapper(JsonFactory factory) {
        ObjectMapper om = new ObjectMapper(factory);
        om.registerModule((Module)new JodaModule());
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        om.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        om.enable(SerializationFeature.INDENT_OUTPUT);
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        om.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        return om;
    }

    public List<ImageTransform> getTransformList() {
        return this.transformList;
    }

    public int getSeed() {
        return this.seed;
    }

    public void setTransformList(List<ImageTransform> transformList) {
        this.transformList = transformList;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageTransformProcess)) {
            return false;
        }
        ImageTransformProcess other = (ImageTransformProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ImageTransform> this$transformList = this.getTransformList();
        List<ImageTransform> other$transformList = other.getTransformList();
        if (this$transformList == null ? other$transformList != null : !((Object)this$transformList).equals(other$transformList)) {
            return false;
        }
        return this.getSeed() == other.getSeed();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImageTransformProcess;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ImageTransform> $transformList = this.getTransformList();
        result = result * 59 + ($transformList == null ? 43 : ((Object)$transformList).hashCode());
        result = result * 59 + this.getSeed();
        return result;
    }

    public String toString() {
        return "ImageTransformProcess(transformList=" + this.getTransformList() + ", seed=" + this.getSeed() + ")";
    }

    public ImageTransformProcess() {
    }

    public static class Builder {
        private List<ImageTransform> transformList = new ArrayList<ImageTransform>();
        private int seed = 0;

        public Builder seed(int seed) {
            this.seed = seed;
            return this;
        }

        public Builder cropImageTransform(int crop) {
            this.transformList.add(new CropImageTransform(crop));
            return this;
        }

        public Builder cropImageTransform(int cropTop, int cropLeft, int cropBottom, int cropRight) {
            this.transformList.add(new CropImageTransform(cropTop, cropLeft, cropBottom, cropRight));
            return this;
        }

        public Builder colorConversionTransform(int conversionCode) {
            this.transformList.add(new ColorConversionTransform(conversionCode));
            return this;
        }

        public Builder equalizeHistTransform(int conversionCode) {
            this.transformList.add(new EqualizeHistTransform(conversionCode));
            return this;
        }

        public Builder filterImageTransform(String filters, int width, int height) {
            this.transformList.add(new FilterImageTransform(filters, width, height));
            return this;
        }

        public Builder filterImageTransform(String filters, int width, int height, int channels) {
            this.transformList.add(new FilterImageTransform(filters, width, height, channels));
            return this;
        }

        public Builder flipImageTransform(int flipMode) {
            this.transformList.add(new FlipImageTransform(flipMode));
            return this;
        }

        public Builder randomCropTransform(int height, int width) {
            this.transformList.add(new RandomCropTransform(height, width));
            return this;
        }

        public Builder randomCropTransform(long seed, int height, int width) {
            this.transformList.add(new RandomCropTransform(seed, height, width));
            return this;
        }

        public Builder resizeImageTransform(int newWidth, int newHeight) {
            this.transformList.add(new ResizeImageTransform(newWidth, newHeight));
            return this;
        }

        public Builder rotateImageTransform(float angle) {
            this.transformList.add(new RotateImageTransform(angle));
            return this;
        }

        public Builder rotateImageTransform(float centerx, float centery, float angle, float scale) {
            this.transformList.add(new RotateImageTransform(centerx, centery, angle, scale));
            return this;
        }

        public Builder scaleImageTransform(float delta) {
            this.transformList.add(new ScaleImageTransform(delta));
            return this;
        }

        public Builder scaleImageTransform(float dx, float dy) {
            this.transformList.add(new ScaleImageTransform(dx, dy));
            return this;
        }

        public Builder warpImageTransform(float delta) {
            this.transformList.add(new WarpImageTransform(delta));
            return this;
        }

        public Builder warpImageTransform(float dx1, float dy1, float dx2, float dy2, float dx3, float dy3, float dx4, float dy4) {
            this.transformList.add(new WarpImageTransform(dx1, dy1, dx2, dy2, dx3, dy3, dx4, dy4));
            return this;
        }

        public ImageTransformProcess build() {
            return new ImageTransformProcess(this);
        }
    }
}

