/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.parameterserver.functions;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.io.LineIterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.datavec.spark.util.SerializableHadoopConfig;
import org.deeplearning4j.api.loader.MultiDataSetLoader;
import org.deeplearning4j.spark.api.TrainingResult;
import org.deeplearning4j.spark.api.TrainingWorker;
import org.deeplearning4j.spark.iterator.PathSparkMultiDataSetIterator;
import org.deeplearning4j.spark.parameterserver.functions.SharedFlatMapPaths;
import org.deeplearning4j.spark.parameterserver.pw.SharedTrainingWrapper;
import org.deeplearning4j.spark.parameterserver.training.SharedTrainingResult;
import org.deeplearning4j.spark.parameterserver.training.SharedTrainingWorker;
import org.nd4j.linalg.dataset.api.MultiDataSet;

public class SharedFlatMapPathsMDS<R extends TrainingResult>
implements FlatMapFunction<Iterator<String>, R> {
    protected final SharedTrainingWorker worker;
    protected final MultiDataSetLoader loader;
    protected final Broadcast<SerializableHadoopConfig> hadoopConfig;

    public SharedFlatMapPathsMDS(TrainingWorker<R> worker, MultiDataSetLoader loader, Broadcast<SerializableHadoopConfig> hadoopConfig) {
        this.worker = (SharedTrainingWorker)worker;
        this.loader = loader;
        this.hadoopConfig = hadoopConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<R> call(Iterator<String> dataSetIterator) throws Exception {
        if (!dataSetIterator.hasNext()) {
            return Collections.emptyIterator();
        }
        File f = SharedFlatMapPaths.toTempFile(dataSetIterator);
        LineIterator lineIter = new LineIterator((Reader)new FileReader(f));
        try {
            SharedTrainingWrapper.getInstance(this.worker.getInstanceId()).attachMDS((Iterator<MultiDataSet>)new PathSparkMultiDataSetIterator((Iterator)lineIter, this.loader, this.hadoopConfig));
            SharedTrainingResult result = SharedTrainingWrapper.getInstance(this.worker.getInstanceId()).run(this.worker);
            Iterator<SharedTrainingResult> iterator = Collections.singletonList(result).iterator();
            return iterator;
        }
        finally {
            lineIter.close();
            f.delete();
        }
    }
}

