/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.parameterserver.iterators;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class VirtualDataSetIterator
implements DataSetIterator {
    protected final List<Iterator<DataSet>> iterators;
    protected final AtomicInteger position;

    public VirtualDataSetIterator(@NonNull List<Iterator<DataSet>> iterators) {
        if (iterators == null) {
            throw new NullPointerException("iterators is marked @NonNull but is null");
        }
        this.iterators = iterators;
        this.position = new AtomicInteger(0);
    }

    public boolean resetSupported() {
        return false;
    }

    public boolean asyncSupported() {
        return true;
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
    }

    public boolean hasNext() {
        return this.position.get() < this.iterators.size() - 1 || this.position.get() < this.iterators.size() && this.iterators.get(this.position.get()).hasNext();
    }

    public DataSet next() {
        if (!this.iterators.get(this.position.get()).hasNext()) {
            this.position.getAndIncrement();
        }
        return this.iterators.get(this.position.get()).next();
    }

    public void remove() {
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public DataSetPreProcessor getPreProcessor() {
        return null;
    }

    public int batch() {
        throw new UnsupportedOperationException();
    }

    public int inputColumns() {
        throw new UnsupportedOperationException();
    }

    public int totalOutcomes() {
        throw new UnsupportedOperationException();
    }

    public DataSet next(int num) {
        throw new UnsupportedOperationException();
    }

    public List<String> getLabels() {
        return null;
    }
}

