/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.parameterserver.iterators;

import java.util.Iterator;
import java.util.Observable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualIterator<E>
extends Observable
implements Iterator<E> {
    private static final Logger log = LoggerFactory.getLogger(VirtualIterator.class);
    protected Iterator<E> iterator;
    protected AtomicBoolean state = new AtomicBoolean(true);

    public VirtualIterator(@NonNull Iterator<E> iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator is marked @NonNull but is null");
        }
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        boolean u = this.iterator.hasNext();
        this.state.compareAndSet(true, u);
        if (!this.state.get()) {
            this.setChanged();
            this.notifyObservers();
        }
        return u;
    }

    @Override
    public E next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        this.iterator.forEachRemaining(action);
        this.state.compareAndSet(true, false);
    }

    public void blockUntilDepleted() {
        while (this.state.get()) {
            LockSupport.parkNanos(1000L);
        }
    }
}

