/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.parameterserver.python;

import java.io.Serializable;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;

public class ArrayDescriptor
implements Serializable {
    private long address;
    private long[] shape;
    private long[] stride;
    DataType type;
    char ordering;
    private static NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();

    public ArrayDescriptor(INDArray array) throws Exception {
        this(array.data().address(), array.shape(), array.stride(), array.data().dataType(), array.ordering());
        if (array.isEmpty()) {
            throw new UnsupportedOperationException("Empty arrays are not supported");
        }
    }

    public ArrayDescriptor(long address, long[] shape, long[] stride, DataType type, char ordering) {
        this.address = address;
        this.shape = shape;
        this.stride = stride;
        this.type = type;
        this.ordering = ordering;
    }

    public long getAddress() {
        return this.address;
    }

    public long[] getShape() {
        return this.shape;
    }

    public long[] getStride() {
        return this.stride;
    }

    public DataType getType() {
        return this.type;
    }

    public char getOrdering() {
        return this.ordering;
    }

    private long size() {
        long s = 1L;
        for (long d : this.shape) {
            s *= d;
        }
        return s;
    }

    public INDArray getArray() {
        Pointer ptr = nativeOps.pointerForAddress(this.address);
        ptr = ptr.limit(this.size());
        DataBuffer buff = Nd4j.createBuffer((Pointer)ptr, (long)this.size(), (DataType)this.type);
        return Nd4j.create((DataBuffer)buff, (long[])this.shape, (long[])this.stride, (long)0L, (char)this.ordering, (DataType)this.type);
    }
}

