/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.graph.scoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.deeplearning4j.datasets.iterator.IteratorMultiDataSetIterator;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class ScoreFlatMapFunctionCGMultiDataSet
implements FlatMapFunction<Iterator<MultiDataSet>, Tuple2<Integer, Double>> {
    private static final Logger log = LoggerFactory.getLogger(ScoreFlatMapFunctionCGMultiDataSet.class);
    private String json;
    private Broadcast<INDArray> params;
    private int minibatchSize;

    public ScoreFlatMapFunctionCGMultiDataSet(String json, Broadcast<INDArray> params, int minibatchSize) {
        this.json = json;
        this.params = params;
        this.minibatchSize = minibatchSize;
    }

    public Iterator<Tuple2<Integer, Double>> call(Iterator<MultiDataSet> dataSetIterator) throws Exception {
        if (!dataSetIterator.hasNext()) {
            return Collections.singletonList(new Tuple2((Object)0, (Object)0.0)).iterator();
        }
        IteratorMultiDataSetIterator iter = new IteratorMultiDataSetIterator(dataSetIterator, this.minibatchSize);
        ComputationGraph network = new ComputationGraph(ComputationGraphConfiguration.fromJson((String)this.json));
        network.init();
        INDArray val = ((INDArray)this.params.value()).unsafeDuplication();
        if (val.length() != network.numParams(false)) {
            throw new IllegalStateException("Network did not have same number of parameters as the broadcast set parameters");
        }
        network.setParams(val);
        ArrayList<Tuple2> out = new ArrayList<Tuple2>();
        while (iter.hasNext()) {
            MultiDataSet ds = (MultiDataSet)iter.next();
            double score = network.score(ds, false);
            int numExamples = (int)ds.getFeatures(0).size(0);
            out.add(new Tuple2((Object)numExamples, (Object)(score * (double)numExamples)));
        }
        Nd4j.getExecutioner().commit();
        return out.iterator();
    }
}

