/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.multilayer.evaluation;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Future;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.deeplearning4j.spark.impl.evaluation.EvaluationRunner;
import org.nd4j.evaluation.IEvaluation;
import org.nd4j.linalg.dataset.DataSet;

public class IEvaluateFlatMapFunction<T extends IEvaluation>
implements FlatMapFunction<Iterator<DataSet>, T[]> {
    protected boolean isCompGraph;
    protected Broadcast<String> json;
    protected Broadcast<byte[]> params;
    protected int evalNumWorkers;
    protected int evalBatchSize;
    protected T[] evaluations;

    public IEvaluateFlatMapFunction(boolean isCompGraph, Broadcast<String> json, Broadcast<byte[]> params, int evalNumWorkers, int evalBatchSize, T[] evaluations) {
        this.isCompGraph = isCompGraph;
        this.json = json;
        this.params = params;
        this.evalNumWorkers = evalNumWorkers;
        this.evalBatchSize = evalBatchSize;
        this.evaluations = evaluations;
    }

    public Iterator<T[]> call(Iterator<DataSet> dataSetIterator) throws Exception {
        if (!dataSetIterator.hasNext()) {
            return Collections.emptyIterator();
        }
        Future<IEvaluation[]> f = EvaluationRunner.getInstance().execute((IEvaluation[])this.evaluations, this.evalNumWorkers, this.evalBatchSize, dataSetIterator, null, this.isCompGraph, this.json, this.params);
        IEvaluation[] result = f.get();
        if (result == null) {
            return Collections.emptyIterator();
        }
        return Collections.singletonList(result).iterator();
    }
}

