/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.paramavg.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.spark.SparkContext;
import org.deeplearning4j.spark.api.stats.SparkTrainingStats;
import org.deeplearning4j.spark.stats.BaseEventStats;
import org.deeplearning4j.spark.stats.EventStats;
import org.deeplearning4j.spark.stats.ExampleCountEventStats;
import org.deeplearning4j.spark.stats.StatsUtils;
import org.deeplearning4j.spark.time.TimeSource;
import org.deeplearning4j.spark.time.TimeSourceProvider;

public class ParameterAveragingTrainingWorkerStats
implements SparkTrainingStats {
    public static final String DEFAULT_DELIMITER = ",";
    public static final String FILENAME_BROADCAST_GET_STATS = "parameterAveragingWorkerBroadcastGetValueTimeMs.txt";
    public static final String FILENAME_INIT_STATS = "parameterAveragingWorkerInitTimeMs.txt";
    public static final String FILENAME_FIT_STATS = "parameterAveragingWorkerFitTimesMs.txt";
    private List<EventStats> parameterAveragingWorkerBroadcastGetValueTimeMs;
    private List<EventStats> parameterAveragingWorkerInitTimeMs;
    private List<EventStats> parameterAveragingWorkerFitTimesMs;
    public static final String PARAMETER_AVERAGING_WORKER_BROADCAST_GET_VALUE_TIME_MS = "ParameterAveragingWorkerBroadcastGetValueTimeMs";
    public static final String PARAMETER_AVERAGING_WORKER_INIT_TIME_MS = "ParameterAveragingWorkerInitTimeMs";
    public static final String PARAMETER_AVERAGING_WORKER_FIT_TIMES_MS = "ParameterAveragingWorkerFitTimesMs";
    private static Set<String> columnNames = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("ParameterAveragingWorkerBroadcastGetValueTimeMs", "ParameterAveragingWorkerInitTimeMs", "ParameterAveragingWorkerFitTimesMs")));

    public ParameterAveragingTrainingWorkerStats(List<EventStats> parameterAveragingWorkerBroadcastGetValueTimeMs, List<EventStats> parameterAveragingWorkerInitTimeMs, List<EventStats> parameterAveragingWorkerFitTimesMs) {
        this.parameterAveragingWorkerBroadcastGetValueTimeMs = parameterAveragingWorkerBroadcastGetValueTimeMs;
        this.parameterAveragingWorkerInitTimeMs = parameterAveragingWorkerInitTimeMs;
        this.parameterAveragingWorkerFitTimesMs = parameterAveragingWorkerFitTimesMs;
    }

    @Override
    public Set<String> getKeySet() {
        return columnNames;
    }

    @Override
    public List<EventStats> getValue(String key) {
        switch (key) {
            case "ParameterAveragingWorkerBroadcastGetValueTimeMs": {
                return this.parameterAveragingWorkerBroadcastGetValueTimeMs;
            }
            case "ParameterAveragingWorkerInitTimeMs": {
                return this.parameterAveragingWorkerInitTimeMs;
            }
            case "ParameterAveragingWorkerFitTimesMs": {
                return this.parameterAveragingWorkerFitTimesMs;
            }
        }
        throw new IllegalArgumentException("Unknown key: \"" + key + "\"");
    }

    @Override
    public String getShortNameForKey(String key) {
        switch (key) {
            case "ParameterAveragingWorkerBroadcastGetValueTimeMs": {
                return "BroadcastGet";
            }
            case "ParameterAveragingWorkerInitTimeMs": {
                return "ModelInit";
            }
            case "ParameterAveragingWorkerFitTimesMs": {
                return "Fit";
            }
        }
        throw new IllegalArgumentException("Unknown key: \"" + key + "\"");
    }

    @Override
    public boolean defaultIncludeInPlots(String key) {
        switch (key) {
            case "ParameterAveragingWorkerBroadcastGetValueTimeMs": 
            case "ParameterAveragingWorkerInitTimeMs": 
            case "ParameterAveragingWorkerFitTimesMs": {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown key: \"" + key + "\"");
    }

    @Override
    public void addOtherTrainingStats(SparkTrainingStats other) {
        if (!(other instanceof ParameterAveragingTrainingWorkerStats)) {
            throw new IllegalArgumentException("Cannot merge ParameterAveragingTrainingWorkerStats with " + (other != null ? other.getClass() : null));
        }
        ParameterAveragingTrainingWorkerStats o = (ParameterAveragingTrainingWorkerStats)other;
        this.parameterAveragingWorkerBroadcastGetValueTimeMs.addAll(o.parameterAveragingWorkerBroadcastGetValueTimeMs);
        this.parameterAveragingWorkerInitTimeMs.addAll(o.parameterAveragingWorkerInitTimeMs);
        this.parameterAveragingWorkerFitTimesMs.addAll(o.parameterAveragingWorkerFitTimesMs);
    }

    @Override
    public SparkTrainingStats getNestedTrainingStats() {
        return null;
    }

    @Override
    public String statsAsString() {
        StringBuilder sb = new StringBuilder();
        String f = "%-55s";
        sb.append(String.format(f, PARAMETER_AVERAGING_WORKER_BROADCAST_GET_VALUE_TIME_MS));
        if (this.parameterAveragingWorkerBroadcastGetValueTimeMs == null) {
            sb.append("-\n");
        } else {
            sb.append(StatsUtils.getDurationAsString(this.parameterAveragingWorkerBroadcastGetValueTimeMs, DEFAULT_DELIMITER)).append("\n");
        }
        sb.append(String.format(f, PARAMETER_AVERAGING_WORKER_INIT_TIME_MS));
        if (this.parameterAveragingWorkerInitTimeMs == null) {
            sb.append("-\n");
        } else {
            sb.append(StatsUtils.getDurationAsString(this.parameterAveragingWorkerInitTimeMs, DEFAULT_DELIMITER)).append("\n");
        }
        sb.append(String.format(f, PARAMETER_AVERAGING_WORKER_FIT_TIMES_MS));
        if (this.parameterAveragingWorkerFitTimesMs == null) {
            sb.append("-\n");
        } else {
            sb.append(StatsUtils.getDurationAsString(this.parameterAveragingWorkerFitTimesMs, DEFAULT_DELIMITER)).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void exportStatFiles(String outputPath, SparkContext sc) throws IOException {
        String d = DEFAULT_DELIMITER;
        StatsUtils.exportStats(this.parameterAveragingWorkerBroadcastGetValueTimeMs, outputPath, FILENAME_BROADCAST_GET_STATS, d, sc);
        StatsUtils.exportStats(this.parameterAveragingWorkerInitTimeMs, outputPath, FILENAME_INIT_STATS, d, sc);
        StatsUtils.exportStats(this.parameterAveragingWorkerFitTimesMs, outputPath, FILENAME_FIT_STATS, d, sc);
    }

    public List<EventStats> getParameterAveragingWorkerBroadcastGetValueTimeMs() {
        return this.parameterAveragingWorkerBroadcastGetValueTimeMs;
    }

    public List<EventStats> getParameterAveragingWorkerInitTimeMs() {
        return this.parameterAveragingWorkerInitTimeMs;
    }

    public List<EventStats> getParameterAveragingWorkerFitTimesMs() {
        return this.parameterAveragingWorkerFitTimesMs;
    }

    public void setParameterAveragingWorkerBroadcastGetValueTimeMs(List<EventStats> parameterAveragingWorkerBroadcastGetValueTimeMs) {
        this.parameterAveragingWorkerBroadcastGetValueTimeMs = parameterAveragingWorkerBroadcastGetValueTimeMs;
    }

    public void setParameterAveragingWorkerInitTimeMs(List<EventStats> parameterAveragingWorkerInitTimeMs) {
        this.parameterAveragingWorkerInitTimeMs = parameterAveragingWorkerInitTimeMs;
    }

    public void setParameterAveragingWorkerFitTimesMs(List<EventStats> parameterAveragingWorkerFitTimesMs) {
        this.parameterAveragingWorkerFitTimesMs = parameterAveragingWorkerFitTimesMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterAveragingTrainingWorkerStats)) {
            return false;
        }
        ParameterAveragingTrainingWorkerStats other = (ParameterAveragingTrainingWorkerStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<EventStats> this$parameterAveragingWorkerBroadcastGetValueTimeMs = this.getParameterAveragingWorkerBroadcastGetValueTimeMs();
        List<EventStats> other$parameterAveragingWorkerBroadcastGetValueTimeMs = other.getParameterAveragingWorkerBroadcastGetValueTimeMs();
        if (this$parameterAveragingWorkerBroadcastGetValueTimeMs == null ? other$parameterAveragingWorkerBroadcastGetValueTimeMs != null : !((Object)this$parameterAveragingWorkerBroadcastGetValueTimeMs).equals(other$parameterAveragingWorkerBroadcastGetValueTimeMs)) {
            return false;
        }
        List<EventStats> this$parameterAveragingWorkerInitTimeMs = this.getParameterAveragingWorkerInitTimeMs();
        List<EventStats> other$parameterAveragingWorkerInitTimeMs = other.getParameterAveragingWorkerInitTimeMs();
        if (this$parameterAveragingWorkerInitTimeMs == null ? other$parameterAveragingWorkerInitTimeMs != null : !((Object)this$parameterAveragingWorkerInitTimeMs).equals(other$parameterAveragingWorkerInitTimeMs)) {
            return false;
        }
        List<EventStats> this$parameterAveragingWorkerFitTimesMs = this.getParameterAveragingWorkerFitTimesMs();
        List<EventStats> other$parameterAveragingWorkerFitTimesMs = other.getParameterAveragingWorkerFitTimesMs();
        return !(this$parameterAveragingWorkerFitTimesMs == null ? other$parameterAveragingWorkerFitTimesMs != null : !((Object)this$parameterAveragingWorkerFitTimesMs).equals(other$parameterAveragingWorkerFitTimesMs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParameterAveragingTrainingWorkerStats;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<EventStats> $parameterAveragingWorkerBroadcastGetValueTimeMs = this.getParameterAveragingWorkerBroadcastGetValueTimeMs();
        result = result * 59 + ($parameterAveragingWorkerBroadcastGetValueTimeMs == null ? 43 : ((Object)$parameterAveragingWorkerBroadcastGetValueTimeMs).hashCode());
        List<EventStats> $parameterAveragingWorkerInitTimeMs = this.getParameterAveragingWorkerInitTimeMs();
        result = result * 59 + ($parameterAveragingWorkerInitTimeMs == null ? 43 : ((Object)$parameterAveragingWorkerInitTimeMs).hashCode());
        List<EventStats> $parameterAveragingWorkerFitTimesMs = this.getParameterAveragingWorkerFitTimesMs();
        result = result * 59 + ($parameterAveragingWorkerFitTimesMs == null ? 43 : ((Object)$parameterAveragingWorkerFitTimesMs).hashCode());
        return result;
    }

    public String toString() {
        return "ParameterAveragingTrainingWorkerStats(parameterAveragingWorkerBroadcastGetValueTimeMs=" + this.getParameterAveragingWorkerBroadcastGetValueTimeMs() + ", parameterAveragingWorkerInitTimeMs=" + this.getParameterAveragingWorkerInitTimeMs() + ", parameterAveragingWorkerFitTimesMs=" + this.getParameterAveragingWorkerFitTimesMs() + ")";
    }

    public static class ParameterAveragingTrainingWorkerStatsHelper {
        private long broadcastStartTime;
        private long broadcastEndTime;
        private long initEndTime;
        private long lastFitStartTime;
        private List<EventStats> fitTimes = new ArrayList<EventStats>();
        private final TimeSource timeSource = TimeSourceProvider.getInstance();

        public void logBroadcastGetValueStart() {
            this.broadcastStartTime = this.timeSource.currentTimeMillis();
        }

        public void logBroadcastGetValueEnd() {
            this.broadcastEndTime = this.timeSource.currentTimeMillis();
        }

        public void logInitEnd() {
            this.initEndTime = this.timeSource.currentTimeMillis();
        }

        public void logFitStart() {
            this.lastFitStartTime = this.timeSource.currentTimeMillis();
        }

        public void logFitEnd(int numExamples) {
            long now = this.timeSource.currentTimeMillis();
            this.fitTimes.add(new ExampleCountEventStats(this.lastFitStartTime, now - this.lastFitStartTime, numExamples));
        }

        public ParameterAveragingTrainingWorkerStats build() {
            ArrayList<EventStats> bList = new ArrayList<EventStats>();
            bList.add(new BaseEventStats(this.broadcastStartTime, this.broadcastEndTime - this.broadcastStartTime));
            ArrayList<EventStats> initList = new ArrayList<EventStats>();
            initList.add(new BaseEventStats(this.broadcastEndTime, this.initEndTime - this.broadcastEndTime));
            return new ParameterAveragingTrainingWorkerStats(bList, initList, this.fitTimes);
        }
    }
}

