/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.util.data;

import java.io.Serializable;

public class ValidationResult
implements Serializable {
    private long countTotal;
    private long countMissingFile;
    private long countTotalValid;
    private long countTotalInvalid;
    private long countLoadingFailure;
    private long countMissingFeatures;
    private long countMissingLabels;
    private long countInvalidFeatures;
    private long countInvalidLabels;
    private long countInvalidDeleted;

    public ValidationResult add(ValidationResult o) {
        if (o == null) {
            return this;
        }
        this.countTotal += o.countTotal;
        this.countMissingFile += o.countMissingFile;
        this.countTotalValid += o.countTotalValid;
        this.countTotalInvalid += o.countTotalInvalid;
        this.countLoadingFailure += o.countLoadingFailure;
        this.countMissingFeatures += o.countMissingFeatures;
        this.countMissingLabels += o.countMissingLabels;
        this.countInvalidFeatures += o.countInvalidFeatures;
        this.countInvalidLabels += o.countInvalidLabels;
        this.countInvalidDeleted += o.countInvalidDeleted;
        return this;
    }

    public static ValidationResultBuilder builder() {
        return new ValidationResultBuilder();
    }

    public ValidationResult(long countTotal, long countMissingFile, long countTotalValid, long countTotalInvalid, long countLoadingFailure, long countMissingFeatures, long countMissingLabels, long countInvalidFeatures, long countInvalidLabels, long countInvalidDeleted) {
        this.countTotal = countTotal;
        this.countMissingFile = countMissingFile;
        this.countTotalValid = countTotalValid;
        this.countTotalInvalid = countTotalInvalid;
        this.countLoadingFailure = countLoadingFailure;
        this.countMissingFeatures = countMissingFeatures;
        this.countMissingLabels = countMissingLabels;
        this.countInvalidFeatures = countInvalidFeatures;
        this.countInvalidLabels = countInvalidLabels;
        this.countInvalidDeleted = countInvalidDeleted;
    }

    public ValidationResult() {
    }

    public long getCountTotal() {
        return this.countTotal;
    }

    public long getCountMissingFile() {
        return this.countMissingFile;
    }

    public long getCountTotalValid() {
        return this.countTotalValid;
    }

    public long getCountTotalInvalid() {
        return this.countTotalInvalid;
    }

    public long getCountLoadingFailure() {
        return this.countLoadingFailure;
    }

    public long getCountMissingFeatures() {
        return this.countMissingFeatures;
    }

    public long getCountMissingLabels() {
        return this.countMissingLabels;
    }

    public long getCountInvalidFeatures() {
        return this.countInvalidFeatures;
    }

    public long getCountInvalidLabels() {
        return this.countInvalidLabels;
    }

    public long getCountInvalidDeleted() {
        return this.countInvalidDeleted;
    }

    public void setCountTotal(long countTotal) {
        this.countTotal = countTotal;
    }

    public void setCountMissingFile(long countMissingFile) {
        this.countMissingFile = countMissingFile;
    }

    public void setCountTotalValid(long countTotalValid) {
        this.countTotalValid = countTotalValid;
    }

    public void setCountTotalInvalid(long countTotalInvalid) {
        this.countTotalInvalid = countTotalInvalid;
    }

    public void setCountLoadingFailure(long countLoadingFailure) {
        this.countLoadingFailure = countLoadingFailure;
    }

    public void setCountMissingFeatures(long countMissingFeatures) {
        this.countMissingFeatures = countMissingFeatures;
    }

    public void setCountMissingLabels(long countMissingLabels) {
        this.countMissingLabels = countMissingLabels;
    }

    public void setCountInvalidFeatures(long countInvalidFeatures) {
        this.countInvalidFeatures = countInvalidFeatures;
    }

    public void setCountInvalidLabels(long countInvalidLabels) {
        this.countInvalidLabels = countInvalidLabels;
    }

    public void setCountInvalidDeleted(long countInvalidDeleted) {
        this.countInvalidDeleted = countInvalidDeleted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationResult)) {
            return false;
        }
        ValidationResult other = (ValidationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCountTotal() != other.getCountTotal()) {
            return false;
        }
        if (this.getCountMissingFile() != other.getCountMissingFile()) {
            return false;
        }
        if (this.getCountTotalValid() != other.getCountTotalValid()) {
            return false;
        }
        if (this.getCountTotalInvalid() != other.getCountTotalInvalid()) {
            return false;
        }
        if (this.getCountLoadingFailure() != other.getCountLoadingFailure()) {
            return false;
        }
        if (this.getCountMissingFeatures() != other.getCountMissingFeatures()) {
            return false;
        }
        if (this.getCountMissingLabels() != other.getCountMissingLabels()) {
            return false;
        }
        if (this.getCountInvalidFeatures() != other.getCountInvalidFeatures()) {
            return false;
        }
        if (this.getCountInvalidLabels() != other.getCountInvalidLabels()) {
            return false;
        }
        return this.getCountInvalidDeleted() == other.getCountInvalidDeleted();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidationResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $countTotal = this.getCountTotal();
        result = result * 59 + (int)($countTotal >>> 32 ^ $countTotal);
        long $countMissingFile = this.getCountMissingFile();
        result = result * 59 + (int)($countMissingFile >>> 32 ^ $countMissingFile);
        long $countTotalValid = this.getCountTotalValid();
        result = result * 59 + (int)($countTotalValid >>> 32 ^ $countTotalValid);
        long $countTotalInvalid = this.getCountTotalInvalid();
        result = result * 59 + (int)($countTotalInvalid >>> 32 ^ $countTotalInvalid);
        long $countLoadingFailure = this.getCountLoadingFailure();
        result = result * 59 + (int)($countLoadingFailure >>> 32 ^ $countLoadingFailure);
        long $countMissingFeatures = this.getCountMissingFeatures();
        result = result * 59 + (int)($countMissingFeatures >>> 32 ^ $countMissingFeatures);
        long $countMissingLabels = this.getCountMissingLabels();
        result = result * 59 + (int)($countMissingLabels >>> 32 ^ $countMissingLabels);
        long $countInvalidFeatures = this.getCountInvalidFeatures();
        result = result * 59 + (int)($countInvalidFeatures >>> 32 ^ $countInvalidFeatures);
        long $countInvalidLabels = this.getCountInvalidLabels();
        result = result * 59 + (int)($countInvalidLabels >>> 32 ^ $countInvalidLabels);
        long $countInvalidDeleted = this.getCountInvalidDeleted();
        result = result * 59 + (int)($countInvalidDeleted >>> 32 ^ $countInvalidDeleted);
        return result;
    }

    public String toString() {
        return "ValidationResult(countTotal=" + this.getCountTotal() + ", countMissingFile=" + this.getCountMissingFile() + ", countTotalValid=" + this.getCountTotalValid() + ", countTotalInvalid=" + this.getCountTotalInvalid() + ", countLoadingFailure=" + this.getCountLoadingFailure() + ", countMissingFeatures=" + this.getCountMissingFeatures() + ", countMissingLabels=" + this.getCountMissingLabels() + ", countInvalidFeatures=" + this.getCountInvalidFeatures() + ", countInvalidLabels=" + this.getCountInvalidLabels() + ", countInvalidDeleted=" + this.getCountInvalidDeleted() + ")";
    }

    public static class ValidationResultBuilder {
        private long countTotal;
        private long countMissingFile;
        private long countTotalValid;
        private long countTotalInvalid;
        private long countLoadingFailure;
        private long countMissingFeatures;
        private long countMissingLabels;
        private long countInvalidFeatures;
        private long countInvalidLabels;
        private long countInvalidDeleted;

        ValidationResultBuilder() {
        }

        public ValidationResultBuilder countTotal(long countTotal) {
            this.countTotal = countTotal;
            return this;
        }

        public ValidationResultBuilder countMissingFile(long countMissingFile) {
            this.countMissingFile = countMissingFile;
            return this;
        }

        public ValidationResultBuilder countTotalValid(long countTotalValid) {
            this.countTotalValid = countTotalValid;
            return this;
        }

        public ValidationResultBuilder countTotalInvalid(long countTotalInvalid) {
            this.countTotalInvalid = countTotalInvalid;
            return this;
        }

        public ValidationResultBuilder countLoadingFailure(long countLoadingFailure) {
            this.countLoadingFailure = countLoadingFailure;
            return this;
        }

        public ValidationResultBuilder countMissingFeatures(long countMissingFeatures) {
            this.countMissingFeatures = countMissingFeatures;
            return this;
        }

        public ValidationResultBuilder countMissingLabels(long countMissingLabels) {
            this.countMissingLabels = countMissingLabels;
            return this;
        }

        public ValidationResultBuilder countInvalidFeatures(long countInvalidFeatures) {
            this.countInvalidFeatures = countInvalidFeatures;
            return this;
        }

        public ValidationResultBuilder countInvalidLabels(long countInvalidLabels) {
            this.countInvalidLabels = countInvalidLabels;
            return this;
        }

        public ValidationResultBuilder countInvalidDeleted(long countInvalidDeleted) {
            this.countInvalidDeleted = countInvalidDeleted;
            return this;
        }

        public ValidationResult build() {
            return new ValidationResult(this.countTotal, this.countMissingFile, this.countTotalValid, this.countTotalInvalid, this.countLoadingFailure, this.countMissingFeatures, this.countMissingLabels, this.countInvalidFeatures, this.countInvalidLabels, this.countInvalidDeleted);
        }

        public String toString() {
            return "ValidationResult.ValidationResultBuilder(countTotal=" + this.countTotal + ", countMissingFile=" + this.countMissingFile + ", countTotalValid=" + this.countTotalValid + ", countTotalInvalid=" + this.countTotalInvalid + ", countLoadingFailure=" + this.countLoadingFailure + ", countMissingFeatures=" + this.countMissingFeatures + ", countMissingLabels=" + this.countMissingLabels + ", countInvalidFeatures=" + this.countInvalidFeatures + ", countInvalidLabels=" + this.countInvalidLabels + ", countInvalidDeleted=" + this.countInvalidDeleted + ")";
        }
    }
}

