/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.rl4j.mdp.gym;

import org.deeplearning4j.gym.Client;
import org.deeplearning4j.gym.ClientFactory;
import org.deeplearning4j.gym.StepReply;
import org.deeplearning4j.rl4j.mdp.MDP;
import org.deeplearning4j.rl4j.mdp.gym.ActionTransformer;
import org.deeplearning4j.rl4j.space.ActionSpace;
import org.deeplearning4j.rl4j.space.HighLowDiscrete;
import org.deeplearning4j.rl4j.space.ObservationSpace;

public class GymEnv<O, A, AS extends ActionSpace<A>>
implements MDP<O, A, AS> {
    public static final String GYM_MONITOR_DIR = "/tmp/gym-dqn";
    private final Client<O, A, AS> client;
    private final String envId;
    private final boolean render;
    private final boolean monitor;
    private ActionTransformer actionTransformer = null;
    private boolean done = false;

    public GymEnv(String envId, boolean render, boolean monitor) {
        this.client = ClientFactory.build((String)envId, (boolean)render);
        this.envId = envId;
        this.render = render;
        this.monitor = monitor;
        if (monitor) {
            this.client.monitorStart(GYM_MONITOR_DIR, true, false);
        }
    }

    public GymEnv(String envId, boolean render, boolean monitor, int[] actions) {
        this(envId, render, monitor);
        this.actionTransformer = new ActionTransformer((HighLowDiscrete)this.getActionSpace(), actions);
    }

    public ObservationSpace<O> getObservationSpace() {
        return this.client.getObservationSpace();
    }

    public AS getActionSpace() {
        if (this.actionTransformer == null) {
            return (AS)this.client.getActionSpace();
        }
        return (AS)((Object)this.actionTransformer);
    }

    public StepReply<O> step(A action) {
        StepReply stepRep = this.client.step(action);
        this.done = stepRep.isDone();
        return stepRep;
    }

    public boolean isDone() {
        return this.done;
    }

    public O reset() {
        this.done = false;
        return (O)this.client.reset();
    }

    public void upload(String apiKey) {
        this.client.upload(GYM_MONITOR_DIR, apiKey);
    }

    public void close() {
        if (this.monitor) {
            this.client.monitorClose();
        }
    }

    public GymEnv<O, A, AS> newInstance() {
        return new GymEnv<O, A, AS>(this.envId, this.render, this.monitor);
    }
}

