/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.timestamp;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.demoiselle.signer.core.Priority;
import org.demoiselle.signer.core.exception.CertificateCoreException;
import org.demoiselle.signer.core.timestamp.TimeStampGenerator;
import org.demoiselle.signer.timestamp.connector.TimeStampOperator;

@Priority(value=0x7FFFFFFF)
public class TimestampGeneratorImpl
implements TimeStampGenerator {
    private byte[] content = null;
    private PrivateKey privateKey;
    private Certificate[] certificates;
    private byte[] hash = null;

    public void initialize(byte[] content, PrivateKey privateKey, Certificate[] certificates, byte[] hash) throws CertificateCoreException {
        this.content = content;
        this.privateKey = privateKey;
        this.certificates = certificates;
        this.hash = hash;
    }

    public byte[] generateTimeStamp() throws CertificateCoreException {
        TimeStampOperator timeStampOperator = new TimeStampOperator();
        byte[] request = timeStampOperator.createRequest(this.privateKey, this.certificates, this.content, this.hash);
        return timeStampOperator.invoke(request);
    }

    public void validateTimeStamp(byte[] content, byte[] timestamp, byte[] hash) throws CertificateCoreException {
        TimeStampOperator timeStampOperator = new TimeStampOperator();
        timeStampOperator.validate(content, timestamp, hash);
    }
}

