/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.timestamp.signer;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Store;
import org.demoiselle.signer.core.keystore.loader.configuration.Configuration;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSigner {
    private static final Logger logger = LoggerFactory.getLogger(RequestSigner.class);
    private static MessagesBundle timeStampMessagesBundle = new MessagesBundle();

    public byte[] signRequest(PrivateKey privateKey, Certificate[] certificates, byte[] request, String algorithm) {
        try {
            logger.info(timeStampMessagesBundle.getString("info.timestamp.sign.request"));
            Security.addProvider((Provider)new BouncyCastleProvider());
            X509Certificate signCert = (X509Certificate)certificates[0];
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            certList.add(signCert);
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            String varAlgorithm = null;
            if (algorithm != null && !algorithm.isEmpty()) {
                varAlgorithm = algorithm;
            } else if (Configuration.getInstance().getSO().toLowerCase().indexOf("indows") > 0) {
                logger.info(timeStampMessagesBundle.getString("info.timestamp.winhash"));
                varAlgorithm = "SHA256withRSA";
            } else {
                logger.info(timeStampMessagesBundle.getString("info.timestamp.linuxhash"));
                varAlgorithm = "SHA512withRSA";
            }
            SignerInfoGenerator signerInfoGenerator = new JcaSimpleSignerInfoGeneratorBuilder().build(varAlgorithm, privateKey, signCert);
            generator.addSignerInfoGenerator(signerInfoGenerator);
            JcaCertStore certStore = new JcaCertStore(certList);
            generator.addCertificates((Store)certStore);
            CMSProcessableByteArray data = new CMSProcessableByteArray(request);
            CMSSignedData signed = generator.generate((CMSTypedData)data, true);
            return signed.getEncoded();
        }
        catch (IOException | CertificateEncodingException | CMSException | OperatorCreationException ex) {
            logger.info(ex.getMessage());
            return null;
        }
    }
}

