/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.ddoc.factory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.digidoc4j.ddoc.utils.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigiDocGenFactory {
    private static Logger m_logger = LoggerFactory.getLogger(DigiDocGenFactory.class);
    private static final String DIGI_OID_LIVE_TEST = "1.3.6.1.4.1.10015.1.2";
    private static final String DIGI_OID_TEST_TEST = "1.3.6.1.4.1.10015.3.2";
    public static final String[] TEST_OIDS_PREFS = new String[]{"1.3.6.1.4.1.10015.3.7", "1.3.6.1.4.1.10015.7", "1.3.6.1.4.1.10015.3.3", "1.3.6.1.4.1.10015.3.11", "1.3.6.1.4.1.10015.3.2", "1.3.6.1.4.1.10015.3.1"};

    private static boolean certHasPolicy(X509Certificate cert, String sOid) {
        try {
            X509Extensions ext;
            ByteArrayInputStream bIn;
            ASN1InputStream aIn;
            ASN1Sequence seq;
            X509CertificateStructure obj;
            TBSCertificateStructure tbsCert;
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("Read cert policies: " + cert.getSerialNumber().toString());
            }
            if ((tbsCert = (obj = new X509CertificateStructure(seq = (ASN1Sequence)(aIn = new ASN1InputStream((InputStream)(bIn = new ByteArrayInputStream(cert.getEncoded())))).readObject())).getTBSCertificate()).getVersion() == 3 && (ext = tbsCert.getExtensions()) != null) {
                Enumeration en = ext.oids();
                while (en.hasMoreElements()) {
                    Object o = en.nextElement();
                    if (!(o instanceof ASN1ObjectIdentifier)) continue;
                    ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)o;
                    X509Extension extVal = ext.getExtension(oid);
                    ASN1OctetString oct = extVal.getValue();
                    ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
                    if (!oid.equals((Object)X509Extension.certificatePolicies)) continue;
                    ASN1Sequence cp = (ASN1Sequence)extIn.readObject();
                    for (int i = 0; i != cp.size(); ++i) {
                        String sId;
                        PolicyInformation pol = PolicyInformation.getInstance((Object)cp.getObjectAt(i));
                        if (pol == null || (sId = pol.getPolicyIdentifier().getId()) == null) continue;
                        if (m_logger.isDebugEnabled()) {
                            m_logger.debug("Policy: " + sId);
                        }
                        if (!sId.startsWith(sOid)) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception ex) {
            m_logger.error("Error reading cert policies: " + ex);
        }
        return false;
    }

    public static boolean isPre2011IdCard(X509Certificate cert) {
        return cert != null && cert.getPublicKey() instanceof RSAPublicKey && ((RSAPublicKey)cert.getPublicKey()).getModulus().bitLength() == 1024 && !DigiDocGenFactory.certHasPolicy(cert, DIGI_OID_LIVE_TEST) && !DigiDocGenFactory.certHasPolicy(cert, DIGI_OID_TEST_TEST);
    }

    public static boolean isTestCard(X509Certificate cert) {
        if (cert != null) {
            String cn = ConvertUtils.getCommonName(cert.getSubjectDN().getName());
            for (int i = 0; i < TEST_OIDS_PREFS.length; ++i) {
                String sOid = TEST_OIDS_PREFS[i];
                if (!(i == 1 ? DigiDocGenFactory.certHasPolicy(cert, sOid) && cn != null && cn.indexOf("TEST") != -1 : DigiDocGenFactory.certHasPolicy(cert, sOid))) continue;
                return true;
            }
        }
        return false;
    }
}

