/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.ddoc;

import java.io.Serializable;
import java.util.ArrayList;
import org.digidoc4j.ddoc.DigiDocException;

public class Identifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_qualifier;
    private String m_oidOrUrn;
    public static String OIDAsURI = "OIDAsURI";
    public static String OIDAsURN = "OIDAsURN";
    public static String BDOC_210_OID = "urn:oid:1.3.6.1.4.1.10015.1000.3.2.1";

    public Identifier(String qualifier) throws DigiDocException {
        this.setQualifier(qualifier);
        this.m_oidOrUrn = null;
    }

    public String getQualifier() {
        return this.m_qualifier;
    }

    public void setQualifier(String str) throws DigiDocException {
        DigiDocException ex = this.validateQualifier(str);
        if (ex != null) {
            throw ex;
        }
        this.m_qualifier = str;
    }

    private DigiDocException validateQualifier(String str) {
        DigiDocException ex = null;
        if (str == null || !str.equals(OIDAsURI) && !str.equals(OIDAsURN)) {
            ex = new DigiDocException(167, "Qualifier is a required attribute and must be OIDAsURI or OIDAsURN", null);
        }
        return ex;
    }

    public String getUri() {
        return this.m_oidOrUrn;
    }

    public void setUri(String str) {
        this.m_oidOrUrn = str;
    }

    public ArrayList validate() {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateQualifier(this.m_qualifier);
        if (ex != null) {
            errs.add(ex);
        }
        return errs;
    }
}

