/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.ddoc;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import org.digidoc4j.ddoc.DataFile;
import org.digidoc4j.ddoc.DigiDocException;
import org.digidoc4j.ddoc.Manifest;
import org.digidoc4j.ddoc.ManifestFileEntry;
import org.digidoc4j.ddoc.Signature;
import org.digidoc4j.ddoc.factory.DigiDocXmlGenFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedDoc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_format;
    private String m_version;
    private ArrayList m_dataFiles;
    private ArrayList m_signatures;
    private Manifest m_manifest;
    private String m_mimeType;
    private String m_nsXmlDsig;
    private String m_nsXades;
    private String m_nsAsic;
    private String m_profile;
    private String m_comment;
    private Hashtable m_sigFormats;
    private long m_size;
    private String m_path;
    private String m_file;
    private static Logger m_logger = LoggerFactory.getLogger(SignedDoc.class);
    public static final String FORMAT_SK_XML = "SK-XML";
    public static final String FORMAT_DIGIDOC_XML = "DIGIDOC-XML";
    public static final String VERSION_1_0 = "1.0";
    public static final String VERSION_1_1 = "1.1";
    public static final String VERSION_1_2 = "1.2";
    public static final String VERSION_1_3 = "1.3";
    public static final String PROFILE_TM = "TM";
    public static final String SHA1_DIGEST_ALGORITHM = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String SHA1_DIGEST_TYPE = "SHA-1";
    public static final String SHA1_DIGEST_TYPE_BAD = "SHA-1-00";
    public static final int SHA1_DIGEST_LENGTH = 20;
    public static final String CANONICALIZATION_METHOD_20010315 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String CANONICALIZATION_METHOD_1_1 = "http://www.w3.org/2006/12/xml-c14n11";
    public static final String CANONICALIZATION_METHOD_2010_10_EXC = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String TRANSFORM_20001026 = "http://www.w3.org/TR/2000/CR-xml-c14n-20001026";
    public static final String RSA_SHA1_SIGNATURE_METHOD = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String ECDSA_SHA1_SIGNATURE_METHOD = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1";
    public static final String DIGIDOC_DETATCHED_TRANSFORM = "http://www.sk.ee/2002/10/digidoc#detatched-document-signature";
    public static final String ENVELOPED_TRANSFORM = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    public static final String SIGNEDPROPERTIES_TYPE = "http://uri.etsi.org/01903#SignedProperties";
    public static String xmlns_xmldsig = "http://www.w3.org/2000/09/xmldsig#";
    public static String xmlns_etsi = "http://uri.etsi.org/01903/v1.1.1#";
    public static String xmlns_digidoc13 = "http://www.sk.ee/DigiDoc/v1.3.0#";
    public static String xmlns_xades_123 = "http://uri.etsi.org/01903/v1.3.2#";

    public SignedDoc() {
        this.m_format = null;
        this.m_version = null;
        this.m_dataFiles = null;
        this.m_signatures = null;
        this.m_manifest = null;
        this.m_mimeType = null;
        this.m_nsXmlDsig = null;
        this.m_nsXades = null;
        this.m_nsAsic = null;
        this.m_file = null;
        this.m_path = null;
        this.m_comment = null;
    }

    public SignedDoc(String format, String version) throws DigiDocException {
        this.setFormatAndVersion(format, version);
        this.m_dataFiles = null;
        this.m_signatures = null;
        this.m_manifest = null;
        this.m_mimeType = null;
        this.m_nsXmlDsig = null;
        this.m_nsXades = null;
        this.m_comment = null;
    }

    public void setDefaultNsPref(String format) {
        if (format.equals(FORMAT_DIGIDOC_XML) || format.equals(FORMAT_SK_XML)) {
            this.m_nsXmlDsig = null;
            this.m_nsXades = null;
            this.m_nsAsic = null;
        }
    }

    public ManifestFileEntry findManifestEntryByPath(String fullPath) {
        return this.m_manifest.findFileEntryByPath(fullPath);
    }

    public String getFormat() {
        return this.m_format;
    }

    public void setFormat(String str) throws DigiDocException {
        DigiDocException ex = this.validateFormat(str);
        if (ex != null) {
            throw ex;
        }
        this.m_format = str;
    }

    public ArrayList getDataFiles() {
        return this.m_dataFiles;
    }

    public void setDataFiles(ArrayList l) {
        this.m_dataFiles = l;
    }

    public ArrayList getSignatures() {
        return this.m_signatures;
    }

    public long getSize() {
        return this.m_size;
    }

    public void setSize(long l) {
        this.m_size = l;
    }

    public String getFile() {
        return this.m_file;
    }

    public void setFile(String fname) {
        this.m_file = fname;
    }

    public String getPath() {
        return this.m_path;
    }

    public void setPath(String p) {
        this.m_path = p;
    }

    public String getComment() {
        return this.m_comment;
    }

    public void setComment(String s) {
        this.m_comment = s;
    }

    public void addSignatureProfile(String sigId, String profile) {
        if (this.m_sigFormats == null) {
            this.m_sigFormats = new Hashtable();
        }
        if (m_logger.isDebugEnabled()) {
            m_logger.debug("Register signature: " + sigId + " profile: " + profile);
        }
        this.m_sigFormats.put(sigId, profile);
    }

    public String findSignatureProfile(String sigId) {
        return this.m_sigFormats != null && sigId != null ? (String)this.m_sigFormats.get(sigId) : null;
    }

    public String getXmlDsigNs() {
        return this.m_nsXmlDsig;
    }

    public void setXmlDsigNs(String str) {
        this.m_nsXmlDsig = str;
    }

    public String getXadesNs() {
        return this.m_nsXades;
    }

    public void setXadesNs(String str) {
        this.m_nsXades = str;
    }

    public String getAsicNs() {
        return this.m_nsAsic;
    }

    public void setAsicNs(String str) {
        this.m_nsAsic = str;
    }

    public String getProfile() {
        return this.m_profile;
    }

    public void setProfile(String s) {
        this.m_profile = s;
    }

    private DigiDocException validateFormat(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(13, "Format attribute is mandatory!", null);
        } else if (!str.equals(FORMAT_SK_XML) && !str.equals(FORMAT_DIGIDOC_XML)) {
            ex = new DigiDocException(13, "Currently supports only SK-XML and DIGIDOC-XML formats", null);
        }
        return ex;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String str) throws DigiDocException {
        DigiDocException ex = this.validateVersion(str);
        if (ex != null) {
            throw ex;
        }
        this.m_version = str;
    }

    private DigiDocException validateVersion(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(13, "Version attribute is mandatory!", null);
        } else if (this.m_format != null) {
            if (this.m_format.equals(FORMAT_SK_XML) && !str.equals(VERSION_1_0)) {
                ex = new DigiDocException(13, "Format SK-XML supports only version 1.0", null);
            }
            if (this.m_format.equals(FORMAT_DIGIDOC_XML) && !str.equals(VERSION_1_1) && !str.equals(VERSION_1_2) && !str.equals(VERSION_1_3)) {
                ex = new DigiDocException(13, "Format DIGIDOC-XML supports only versions 1.1, 1.2, 1.3", null);
            }
        }
        return ex;
    }

    public void setFormatAndVersion(String sFormat, String sVersion) throws DigiDocException {
        this.m_format = sFormat;
        this.m_version = sVersion;
        DigiDocException ex = this.validateFormatAndVersion();
        if (ex != null) {
            throw ex;
        }
    }

    public DigiDocException validateFormatAndVersion() {
        Object ex = null;
        if (this.m_format == null || this.m_version == null) {
            return new DigiDocException(13, "Format and version attributes are mandatory!", null);
        }
        if (this.m_format.equals(FORMAT_DIGIDOC_XML) || this.m_format.equals(FORMAT_SK_XML)) {
            if (!this.m_version.equals(VERSION_1_3)) {
                return new DigiDocException(13, "Only format DIGIDOC-XML version 1.3 is supported!", null);
            }
        } else {
            return new DigiDocException(13, "Invalid format attribute!", null);
        }
        return null;
    }

    public Manifest getManifest() {
        return this.m_manifest;
    }

    public void setManifest(Manifest m) {
        this.m_manifest = m;
    }

    public String getMimeType() {
        return this.m_mimeType;
    }

    public void setMimeType(String str) {
        this.m_mimeType = str;
    }

    public int countDataFiles() {
        return this.m_dataFiles == null ? 0 : this.m_dataFiles.size();
    }

    public void cleanupDfCache() {
        for (int i = 0; this.m_dataFiles != null && i < this.m_dataFiles.size(); ++i) {
            DataFile df = (DataFile)this.m_dataFiles.get(i);
            df.cleanupDfCache();
        }
    }

    public String getNewDataFileId() {
        int nDf = 0;
        String id = "D" + nDf;
        boolean bExists = false;
        do {
            bExists = false;
            for (int d = 0; d < this.countDataFiles(); ++d) {
                DataFile df = this.getDataFile(d);
                if (!df.getId().equals(id)) continue;
                id = "D" + ++nDf;
                bExists = true;
            }
        } while (bExists);
        return id;
    }

    public DataFile addDataFile(File inputFile, String mime, String contentType) throws DigiDocException {
        DigiDocException ex1 = this.validateFormatAndVersion();
        if (ex1 != null) {
            throw ex1;
        }
        DataFile df = new DataFile(this.getNewDataFileId(), contentType, inputFile.getAbsolutePath(), mime, this);
        if (inputFile.canRead()) {
            df.setSize(inputFile.length());
        }
        this.addDataFile(df);
        return df;
    }

    public void writeToFile(File outputFile) throws DigiDocException {
        try {
            FileOutputStream os = new FileOutputStream(outputFile);
            this.writeToStream(os);
            ((OutputStream)os).close();
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 11);
        }
    }

    public void writeToStream(OutputStream os) throws DigiDocException {
        DigiDocException ex1 = this.validateFormatAndVersion();
        if (ex1 != null) {
            throw ex1;
        }
        try {
            DigiDocXmlGenFactory genFac = new DigiDocXmlGenFactory(this);
            if (this.m_format.equals(FORMAT_DIGIDOC_XML)) {
                int i;
                os.write(this.xmlHeader().getBytes());
                for (i = 0; i < this.countDataFiles(); ++i) {
                    DataFile df = this.getDataFile(i);
                    df.writeToFile(os);
                    os.write("\n".getBytes());
                }
                for (i = 0; i < this.countSignatures(); ++i) {
                    Signature sig = this.getSignature(i);
                    if (sig.getOrigContent() != null) {
                        os.write(sig.getOrigContent());
                    } else {
                        os.write(genFac.signatureToXML(sig));
                    }
                    os.write("\n".getBytes());
                }
                os.write(this.xmlTrailer().getBytes());
            }
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 11);
        }
    }

    public void addDataFile(DataFile df) throws DigiDocException {
        if (this.countSignatures() > 0) {
            throw new DigiDocException(14, "Cannot add DataFiles when signatures exist!", null);
        }
        if (this.m_dataFiles == null) {
            this.m_dataFiles = new ArrayList();
        }
        if (df.getId() == null) {
            df.setId(this.getNewDataFileId());
        }
        this.m_dataFiles.add(df);
    }

    public DataFile getDataFile(int idx) {
        if (this.m_dataFiles != null && idx >= 0 && idx < this.m_dataFiles.size()) {
            return (DataFile)this.m_dataFiles.get(idx);
        }
        return null;
    }

    public DataFile getLastDataFile() {
        if (this.m_dataFiles != null && this.m_dataFiles.size() > 0) {
            return (DataFile)this.m_dataFiles.get(this.m_dataFiles.size() - 1);
        }
        return null;
    }

    public int countSignatures() {
        return this.m_signatures == null ? 0 : this.m_signatures.size();
    }

    public Signature findSignatureById(String sigId) {
        for (int i = 0; i < this.countSignatures(); ++i) {
            Signature sig = this.getSignature(i);
            if (!sig.getId().equals(sigId)) continue;
            return sig;
        }
        return null;
    }

    public Signature findSignatureByPath(String path) {
        for (int i = 0; i < this.countSignatures(); ++i) {
            Signature sig = this.getSignature(i);
            if (sig.getPath() == null || !sig.getPath().equals(path)) continue;
            return sig;
        }
        return null;
    }

    public void addSignature(Signature sig) {
        if (this.m_signatures == null) {
            this.m_signatures = new ArrayList();
        }
        this.m_signatures.add(sig);
    }

    public Signature getSignature(int idx) {
        if (this.m_signatures != null && idx >= 0 && idx < this.m_signatures.size()) {
            return (Signature)this.m_signatures.get(idx);
        }
        return null;
    }

    public Signature getLastSignature() {
        if (this.m_signatures != null && this.m_signatures.size() > 0) {
            return (Signature)this.m_signatures.get(this.m_signatures.size() - 1);
        }
        return null;
    }

    public ArrayList validate(boolean bStrong) {
        ArrayList e;
        int i;
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateFormat(this.m_format);
        if (ex != null) {
            errs.add(ex);
        }
        if ((ex = this.validateVersion(this.m_version)) != null) {
            errs.add(ex);
        }
        if (this.m_format != null && this.m_version != null && (this.m_format.equals(FORMAT_SK_XML) || this.m_format.equals(FORMAT_DIGIDOC_XML) && (this.m_version.equals(VERSION_1_1) || this.m_version.equals(VERSION_1_2)))) {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("Old and unsupported format: " + this.m_format + " version: " + this.m_version);
            }
            ex = new DigiDocException(177, "Old and unsupported format: " + this.m_format + " version: " + this.m_version, null);
            errs.add(ex);
        }
        for (i = 0; i < this.countDataFiles(); ++i) {
            DataFile df = this.getDataFile(i);
            e = df.validate(bStrong);
            if (e.isEmpty()) continue;
            errs.addAll(e);
        }
        for (i = 0; i < this.countSignatures(); ++i) {
            Signature sig = this.getSignature(i);
            e = sig.validate();
            if (e.isEmpty()) continue;
            errs.addAll(e);
        }
        return errs;
    }

    public static boolean hasFatalErrs(ArrayList lerrs) {
        for (int i = 0; lerrs != null && i < lerrs.size(); ++i) {
            DigiDocException ex = (DigiDocException)lerrs.get(i);
            if (ex.getCode() != 75) continue;
            return true;
        }
        return false;
    }

    public ArrayList verify(boolean checkDate, boolean demandConfirmation) {
        ArrayList errs = this.validate(true);
        if (SignedDoc.hasFatalErrs(errs)) {
            return errs;
        }
        for (int i = 0; i < this.countSignatures(); ++i) {
            Signature sig = this.getSignature(i);
            ArrayList e = sig.verify(this, checkDate, demandConfirmation);
            if (e.isEmpty()) continue;
            errs.addAll(e);
        }
        if (this.countSignatures() == 0) {
            errs.add(new DigiDocException(98, "This document is not signed!", null));
        }
        return errs;
    }

    private String xmlHeader() {
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        if (this.m_format.equals(FORMAT_DIGIDOC_XML)) {
            sb.append("<SignedDoc format=\"");
            sb.append(this.m_format);
            sb.append("\" version=\"");
            sb.append(this.m_version);
            sb.append("\"");
            if (this.m_version.equals(VERSION_1_3)) {
                sb.append(" xmlns=\"");
                sb.append(xmlns_digidoc13);
                sb.append("\"");
            }
            sb.append(">\n");
        }
        return sb.toString();
    }

    private String xmlTrailer() {
        if (this.m_format.equals(FORMAT_DIGIDOC_XML)) {
            return "\n</SignedDoc>";
        }
        return "";
    }

    public String toXML() throws DigiDocException {
        String str;
        int i;
        StringBuffer sb = new StringBuffer(this.xmlHeader());
        for (i = 0; i < this.countDataFiles(); ++i) {
            DataFile df = this.getDataFile(i);
            str = df.toString();
            sb.append(str);
            sb.append("\n");
        }
        for (i = 0; i < this.countSignatures(); ++i) {
            Signature sig = this.getSignature(i);
            str = sig.toString();
            sb.append(str);
            sb.append("\n");
        }
        sb.append(this.xmlTrailer());
        return sb.toString();
    }

    public String toString() {
        String str = null;
        try {
            str = this.toXML();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    public static byte[] digest(byte[] data) throws DigiDocException {
        return SignedDoc.digestOfType(data, SHA1_DIGEST_TYPE);
    }

    public static byte[] digestOfType(byte[] data, String digType) throws DigiDocException {
        byte[] dig = null;
        try {
            MessageDigest sha = MessageDigest.getInstance(digType, "BC");
            sha.update(data);
            dig = sha.digest();
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 54);
        }
        return dig;
    }

    private static String getDnPart(String sDn, String sField, String sOid) {
        if (sDn != null && sDn.length() > 0) {
            String s = sField + "=";
            boolean bQ = false;
            int n1 = sDn.toUpperCase().indexOf(s.toUpperCase());
            if (n1 == -1 && sOid != null) {
                s = "OID." + sOid + "=";
                n1 = sDn.toUpperCase().indexOf(s.toUpperCase());
            }
            if (n1 >= 0) {
                int n2;
                if (sDn.charAt(n1 += s.length()) == '\"') {
                    bQ = true;
                    ++n1;
                }
                if ((n2 = sDn.indexOf(bQ ? "\", " : ", ", n1)) == -1) {
                    n2 = sDn.length();
                }
                if (n2 > n1 && n2 <= sDn.length()) {
                    return sDn.substring(n1, n2);
                }
            }
        }
        return null;
    }

    public static String getSubjectFirstName(X509Certificate cert) {
        String dn = SignedDoc.getDN(cert);
        String name = null;
        String cn = SignedDoc.getDnPart(dn, "CN", null);
        if (cn != null) {
            int idx2;
            int idx1;
            for (idx1 = 0; idx1 < cn.length() && cn.charAt(idx1) != ','; ++idx1) {
            }
            if (idx1 < cn.length()) {
                ++idx1;
            }
            for (idx2 = idx1; idx2 < cn.length() && cn.charAt(idx2) != ',' && cn.charAt(idx2) != '/'; ++idx2) {
            }
            name = cn.substring(idx1, idx2);
        }
        return name;
    }

    public static String getSubjectLastName(X509Certificate cert) {
        String dn = SignedDoc.getDN(cert);
        String name = null;
        String cn = SignedDoc.getDnPart(dn, "CN", null);
        if (cn != null) {
            int idx2;
            int idx1;
            for (idx1 = 0; idx1 < cn.length() && !Character.isLetter(cn.charAt(idx1)); ++idx1) {
            }
            for (idx2 = idx1; idx2 < cn.length() && cn.charAt(idx2) != ',' && dn.charAt(idx2) != '/'; ++idx2) {
            }
            name = cn.substring(idx1, idx2);
        }
        return name;
    }

    public static String getSubjectPersonalCode(X509Certificate cert) {
        String dn = SignedDoc.getDN(cert);
        String code = SignedDoc.getDnPart(dn, "SERIALNUMBER", "2.5.4.5");
        if (code != null) {
            return code;
        }
        String cn = SignedDoc.getDnPart(dn, "CN", null);
        if (cn != null) {
            int idx2;
            int idx1;
            for (idx1 = 0; idx1 < cn.length() && !Character.isDigit(cn.charAt(idx1)); ++idx1) {
            }
            for (idx2 = idx1; idx2 < cn.length() && Character.isDigit(cn.charAt(idx2)); ++idx2) {
            }
            if (idx2 > idx1 + 7) {
                code = cn.substring(idx1, idx2);
            }
        }
        return code;
    }

    private static String getDN(X509Certificate cert) {
        return cert.getSubjectX500Principal().getName("RFC1779");
    }

    public static String getCommonName(String dn) {
        return SignedDoc.getDnPart(dn, "CN", null);
    }

    public static X509Certificate readCertificate(byte[] data) throws DigiDocException {
        X509Certificate cert = null;
        try {
            ByteArrayInputStream certStream = new ByteArrayInputStream(data);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(certStream);
            certStream.close();
        }
        catch (Exception ex) {
            m_logger.error("Error reading certificate: " + ex);
            return null;
        }
        return cert;
    }

    public static byte[] readFile(File inFile) throws IOException, FileNotFoundException {
        byte[] data = null;
        FileInputStream is = new FileInputStream(inFile);
        DataInputStream dis = new DataInputStream(is);
        data = new byte[dis.available()];
        dis.readFully(data);
        dis.close();
        is.close();
        return data;
    }

    public static boolean compareDigests(byte[] dig1, byte[] dig2) {
        boolean ok = dig1 != null && dig2 != null && dig1.length == dig2.length;
        for (int i = 0; ok && i < dig1.length; ++i) {
            if (dig1[i] == dig2[i]) continue;
            ok = false;
        }
        return ok;
    }

    public static String bin2hex(byte[] arr) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            String str = Integer.toHexString(arr[i]);
            if (str.length() == 2) {
                sb.append(str);
            }
            if (str.length() < 2) {
                sb.append("0");
                sb.append(str);
            }
            if (str.length() <= 2) continue;
            sb.append(str.substring(str.length() - 2));
        }
        return sb.toString();
    }
}

