/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.ddoc;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Vector;
import org.digidoc4j.ddoc.Base64Util;
import org.digidoc4j.ddoc.CertValue;
import org.digidoc4j.ddoc.CompleteCertificateRefs;
import org.digidoc4j.ddoc.CompleteRevocationRefs;
import org.digidoc4j.ddoc.DigiDocException;
import org.digidoc4j.ddoc.Notary;
import org.digidoc4j.ddoc.OcspRef;
import org.digidoc4j.ddoc.Signature;
import org.digidoc4j.ddoc.SignedDoc;
import org.digidoc4j.ddoc.factory.NotaryFactory;
import org.digidoc4j.ddoc.utils.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsignedProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Signature m_signature;
    private CompleteCertificateRefs m_certRefs;
    private CompleteRevocationRefs m_revRefs;
    private Vector m_notaries;
    private static Logger m_logger = LoggerFactory.getLogger(UnsignedProperties.class);

    public UnsignedProperties(Signature sig) {
        this.m_signature = sig;
        this.m_certRefs = null;
        this.m_revRefs = null;
        this.m_notaries = null;
    }

    public UnsignedProperties(Signature sig, CompleteCertificateRefs crefs, CompleteRevocationRefs rrefs) throws DigiDocException {
        this.m_signature = sig;
        this.setCompleteCertificateRefs(crefs);
        this.setCompleteRevocationRefs(rrefs);
    }

    public CompleteCertificateRefs getCompleteCertificateRefs() {
        return this.m_certRefs;
    }

    public Signature getSignature() {
        return this.m_signature;
    }

    public void setCompleteCertificateRefs(CompleteCertificateRefs crefs) throws DigiDocException {
        this.m_certRefs = crefs;
    }

    public CompleteRevocationRefs getCompleteRevocationRefs() {
        return this.m_revRefs;
    }

    public void setCompleteRevocationRefs(CompleteRevocationRefs refs) throws DigiDocException {
        this.m_revRefs = refs;
    }

    public X509Certificate getRespondersCertificate() {
        CertValue cval;
        X509Certificate cert = null;
        if (this.m_signature != null && (cval = this.m_signature.getCertValueOfType(2)) != null) {
            cert = cval.getCert();
        }
        return cert;
    }

    public void setRespondersCertificate(X509Certificate cert) throws DigiDocException {
        if (this.m_signature != null && cert != null) {
            CertValue cval = this.m_signature.getOrCreateCertValueOfType(2);
            cval.setId(this.m_signature.getId() + "-RESPONDER_CERT");
            cval.setCert(cert);
        }
    }

    private DigiDocException validateRespondersCertificate(X509Certificate cert) {
        DigiDocException ex = null;
        return ex;
    }

    public Notary getNotaryById(int nIdx) {
        if (this.m_notaries != null && nIdx < this.m_notaries.size()) {
            return (Notary)this.m_notaries.elementAt(nIdx);
        }
        return null;
    }

    public void addNotary(Notary not) {
        if (this.m_notaries == null) {
            this.m_notaries = new Vector();
        }
        this.m_notaries.add(not);
    }

    public int countNotaries() {
        return this.m_notaries != null ? this.m_notaries.size() : 0;
    }

    public Notary getNotary() {
        return this.getNotaryById(0);
    }

    public Notary getLastNotary() {
        return this.getNotaryById(this.countNotaries() - 1);
    }

    public void setNotary(Notary not) throws DigiDocException {
        this.addNotary(not);
    }

    public ArrayList verify(SignedDoc sdoc) {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        X509Certificate cert = this.getRespondersCertificate();
        if (m_logger.isDebugEnabled()) {
            m_logger.debug("Responders cert: " + cert.getSerialNumber() + " - " + cert.getSubjectDN().getName() + " complete cert refs nr: " + this.m_certRefs.getCertSerial() + " - " + this.m_certRefs.getCertIssuer());
        }
        if (cert == null) {
            errs.add(new DigiDocException(53, "No notarys certificate!", null));
            return errs;
        }
        if (cert != null && !cert.getSerialNumber().equals(this.m_certRefs.getCertSerial())) {
            errs.add(new DigiDocException(53, "Wrong notarys certificate: " + cert.getSerialNumber() + " ref: " + this.m_certRefs.getCertSerial(), null));
        }
        try {
            byte[] digest = SignedDoc.digestOfType(cert.getEncoded(), "SHA-1");
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("Not cert calc hash: " + Base64Util.encode(digest, 0) + " cert-ref hash: " + Base64Util.encode(this.m_certRefs.getCertDigestValue(), 0));
            }
            if (!SignedDoc.compareDigests(digest, this.m_certRefs.getCertDigestValue())) {
                errs.add(new DigiDocException(53, "Notary certificates digest doesn't match!", null));
                m_logger.error("Notary certificates digest doesn't match!");
            }
        }
        catch (DigiDocException ex) {
            errs.add(ex);
        }
        catch (Exception ex) {
            errs.add(new DigiDocException(53, "Error calculating notary certificate digest!", null));
        }
        try {
            for (int i = 0; i < this.countNotaries(); ++i) {
                Notary not = this.getNotaryById(i);
                byte[] ocspData = not.getOcspResponseData();
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("OCSP value: " + not.getId() + " data: " + (ocspData != null ? ocspData.length : 0) + " bytes");
                }
                if (ocspData == null || ocspData.length == 0) {
                    errs.add(new DigiDocException(83, "OCSP value is empty!", null));
                    continue;
                }
                OcspRef orf = this.m_revRefs.getOcspRefByUri("#" + not.getId());
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("OCSP ref: " + (orf != null ? orf.getUri() : "NULL"));
                }
                if (orf == null) {
                    errs.add(new DigiDocException(83, "No OCSP ref for uri: #" + not.getId(), null));
                    continue;
                }
                byte[] digest1 = SignedDoc.digestOfType(ocspData, "SHA-1");
                byte[] digest2 = orf.getDigestValue();
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("Check ocsp: " + not.getId() + " calc hash: " + Base64Util.encode(digest1, 0) + " refs-hash: " + Base64Util.encode(digest2, 0));
                }
                if (SignedDoc.compareDigests(digest1, digest2)) continue;
                errs.add(new DigiDocException(83, "Notarys digest doesn't match!", null));
                m_logger.error("Notarys digest doesn't match!");
            }
        }
        catch (DigiDocException ex) {
            errs.add(ex);
        }
        try {
            NotaryFactory notFac = ConfigManager.instance().getNotaryFactory();
            for (int i = 0; i < this.countNotaries(); ++i) {
                Notary not = this.getNotaryById(i);
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug("Verify notray: " + not.getId() + " ocsp: " + (not.getOcspResponseData() != null ? not.getOcspResponseData().length : 0) + " responder: " + not.getResponderId());
                }
                notFac.parseAndVerifyResponse(this.m_signature, not);
            }
        }
        catch (DigiDocException ex) {
            errs.add(ex);
        }
        return errs;
    }

    public ArrayList validate() {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = null;
        X509Certificate cert = this.getRespondersCertificate();
        if (cert == null) {
            ex = this.validateRespondersCertificate(cert);
        }
        if (ex != null) {
            errs.add(ex);
        }
        ArrayList e = null;
        if (this.m_certRefs != null && !(e = this.m_certRefs.validate()).isEmpty()) {
            errs.addAll(e);
        }
        if (this.m_revRefs != null && !(e = this.m_revRefs.validate()).isEmpty()) {
            errs.addAll(e);
        }
        return errs;
    }
}

