/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.ddoc;

import java.io.Serializable;
import java.util.ArrayList;
import org.digidoc4j.ddoc.DigiDocException;
import org.digidoc4j.ddoc.ObjectIdentifier;

public class DataObjectFormat
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_objectReference;
    private String m_description;
    private ObjectIdentifier m_objectIdentifier;
    private String m_mimeType;
    private String m_encoding;

    public DataObjectFormat(String objRef) throws DigiDocException {
        this.setObjectReference(objRef);
        this.m_description = null;
        this.m_mimeType = null;
        this.m_encoding = null;
        this.m_objectIdentifier = null;
    }

    public String getObjectReference() {
        return this.m_objectReference;
    }

    public void setObjectReference(String str) throws DigiDocException {
        DigiDocException ex = this.validateObjectReference(str);
        if (ex != null) {
            throw ex;
        }
        this.m_objectReference = str;
    }

    private DigiDocException validateObjectReference(String str) {
        DigiDocException ex = null;
        if (str == null || str.trim().length() == 0) {
            ex = new DigiDocException(167, "ObjectReference is a required attribute", null);
        }
        return ex;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String str) {
        this.m_description = str;
    }

    public String getMimeType() {
        return this.m_mimeType;
    }

    public void setMimeType(String str) {
        this.m_mimeType = str;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public void setEncoding(String str) {
        this.m_encoding = str;
    }

    public ObjectIdentifier getObjectIdentifier() {
        return this.m_objectIdentifier;
    }

    public void setObjectIdentifier(ObjectIdentifier oid) {
        this.m_objectIdentifier = oid;
    }

    public ArrayList validate() {
        ArrayList e;
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateObjectReference(this.m_objectReference);
        if (ex != null) {
            errs.add(ex);
        }
        if (this.m_objectIdentifier != null && (e = this.m_objectIdentifier.validate()) != null && e.size() > 0) {
            errs.addAll(e);
        }
        return errs;
    }
}

