/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.ddoc;

import java.io.Serializable;
import java.util.ArrayList;
import org.digidoc4j.ddoc.DigiDocException;
import org.digidoc4j.ddoc.Signature;

public class SignatureValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_id;
    private byte[] m_value;
    private Signature m_sig;
    public static final int SIGNATURE_VALUE_LENGTH = 128;

    public SignatureValue() {
        this.m_id = null;
        this.m_value = null;
    }

    public SignatureValue(String id, byte[] value, boolean isEC) throws DigiDocException {
        this.setId(id);
        this.setValue(value, isEC);
    }

    public SignatureValue(Signature sig, byte[] value) throws DigiDocException {
        this.setId(sig.getId() + "-SIG");
        this.m_sig = sig;
        this.setValue(value, sig.isEllipticCurveSiganture());
    }

    public SignatureValue(Signature sig, String id) throws DigiDocException {
        this.m_sig = sig;
        if (id != null) {
            this.setId(id);
        } else {
            this.setId(sig.getId() + "-SIG");
        }
        sig.setSignatureValue(this);
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String str) throws DigiDocException {
        DigiDocException ex = this.validateId(str);
        if (ex != null) {
            throw ex;
        }
        this.m_id = str;
    }

    private DigiDocException validateId(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(37, "Id is a required attribute", null);
        }
        return ex;
    }

    public byte[] getValue() {
        return this.m_value;
    }

    public void setValue(byte[] data, boolean isEC) throws DigiDocException {
        DigiDocException ex = this.validateValue(data, isEC);
        if (ex != null) {
            throw ex;
        }
        this.m_value = data;
    }

    private DigiDocException validateValue(byte[] value, boolean isEC) {
        DigiDocException ex = null;
        if (value == null || value.length < 128 && !isEC) {
            ex = new DigiDocException(37, "RSA signature value must be at least 128 bytes", null);
        }
        return ex;
    }

    public ArrayList validate() {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateValue(this.m_value, this.m_sig != null ? this.m_sig.isEllipticCurveSiganture() : false);
        if (ex != null) {
            errs.add(ex);
        }
        return errs;
    }
}

