/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.ddoc;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;
import org.digidoc4j.ddoc.DigiDocException;
import org.digidoc4j.ddoc.IncludeInfo;
import org.digidoc4j.ddoc.Signature;

public class TimestampInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_id;
    private Signature m_signature;
    private int m_type;
    private ArrayList m_includes;
    private transient TimeStampResponse m_tresp;
    private transient TimeStampToken m_tsTok;
    private transient TimeStampTokenInfo m_tsTinfo;
    private byte[] m_hash;
    public static final int TIMESTAMP_TYPE_UNKNOWN = 0;
    public static final int TIMESTAMP_TYPE_ALL_DATA_OBJECTS = 1;
    public static final int TIMESTAMP_TYPE_INDIVIDUAL_DATA_OBJECTS = 2;
    public static final int TIMESTAMP_TYPE_SIGNATURE = 3;
    public static final int TIMESTAMP_TYPE_SIG_AND_REFS = 4;
    public static final int TIMESTAMP_TYPE_REFS_ONLY = 5;
    public static final int TIMESTAMP_TYPE_ARCHIVE = 6;
    public static final int TIMESTAMP_TYPE_XADES = 7;

    public TimestampInfo() {
        this.m_id = null;
        this.m_signature = null;
        this.m_includes = null;
        this.m_hash = null;
        this.m_type = 0;
        this.m_tsTok = null;
    }

    public TimestampInfo(String id, Signature sig, int type, byte[] hash, TimeStampToken tok) {
        this.m_id = id;
        this.m_signature = sig;
        this.m_includes = null;
        this.m_hash = hash;
        this.m_type = type;
        this.m_tsTok = tok;
    }

    public TimestampInfo(String id, Signature sig, int type, byte[] hash, TimeStampResponse tresp) {
        this.m_id = id;
        this.m_signature = sig;
        this.m_includes = null;
        this.m_hash = hash;
        this.m_type = type;
        this.m_tresp = tresp;
        this.m_tsTok = tresp.getTimeStampToken();
        this.m_tsTinfo = tresp.getTimeStampToken().getTimeStampInfo();
    }

    public Signature getSignature() {
        return this.m_signature;
    }

    public TimeStampResponse getTimeStampResponse() {
        return this.m_tresp;
    }

    public void setTimeStampResponse(TimeStampResponse rsp) {
        this.m_tresp = rsp;
    }

    public void setSignature(Signature sig) {
        this.m_signature = sig;
    }

    public TimestampInfo(String id, int type) throws DigiDocException {
        this.setId(id);
        this.setType(type);
        this.m_includes = null;
    }

    public byte[] getHash() {
        return this.m_hash;
    }

    public void setHash(byte[] b) {
        this.m_hash = b;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String str) throws DigiDocException {
        DigiDocException ex = this.validateId(str);
        if (ex != null) {
            throw ex;
        }
        this.m_id = str;
    }

    private DigiDocException validateId(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(122, "Id atribute cannot be empty", null);
        }
        return ex;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int n) throws DigiDocException {
        DigiDocException ex = this.validateType(n);
        if (ex != null) {
            throw ex;
        }
        this.m_type = n;
    }

    private DigiDocException validateType(int n) {
        DigiDocException ex = null;
        if (n < 1 || n > 7) {
            ex = new DigiDocException(123, "Invalid timestamp type", null);
        }
        return ex;
    }

    public TimeStampToken getTimeStampToken() {
        return this.m_tsTok;
    }

    public void setTimeStampToken(TimeStampToken tst) throws DigiDocException {
        DigiDocException ex = this.validateTimeStampToken(tst);
        if (ex != null) {
            throw ex;
        }
        this.m_tsTok = tst;
    }

    private DigiDocException validateTimeStampToken(TimeStampToken tst) {
        DigiDocException ex = null;
        if (tst == null) {
            ex = new DigiDocException(124, "timestamp token cannot be null", null);
        }
        return ex;
    }

    public int countIncludeInfos() {
        return this.m_includes == null ? 0 : this.m_includes.size();
    }

    public void addIncludeInfo(IncludeInfo inc) {
        if (this.m_includes == null) {
            this.m_includes = new ArrayList();
        }
        inc.setTimestampInfo(this);
        this.m_includes.add(inc);
    }

    public IncludeInfo getIncludeInfo(int idx) {
        if (this.m_includes != null && idx < this.m_includes.size()) {
            return (IncludeInfo)this.m_includes.get(idx);
        }
        return null;
    }

    public IncludeInfo getLastIncludeInfo() {
        if (this.m_includes != null && this.m_includes.size() > 0) {
            return (IncludeInfo)this.m_includes.get(this.m_includes.size() - 1);
        }
        return null;
    }

    public String getAlgorithmOid() {
        String oid = null;
        if (this.m_tsTinfo != null) {
            oid = this.m_tsTinfo.getMessageImprintAlgOID().getId();
        }
        return oid;
    }

    public String getPolicy() {
        String oid = null;
        if (this.m_tsTinfo != null) {
            oid = this.m_tsTinfo.getPolicy().getId();
        }
        return oid;
    }

    public Date getTime() {
        Date d = null;
        if (this.m_tsTinfo != null) {
            d = this.m_tsTok.getTimeStampInfo().getGenTime();
        }
        return d;
    }

    public byte[] getMessageImprint() {
        byte[] b = null;
        if (this.m_tsTok != null) {
            b = this.m_tsTok.getTimeStampInfo().getMessageImprintDigest();
        }
        return b;
    }

    public BigInteger getNonce() {
        BigInteger b = null;
        if (this.m_tsTok != null) {
            b = this.m_tsTok.getTimeStampInfo().getNonce();
        }
        return b;
    }

    public BigInteger getSerialNumber() {
        BigInteger b = null;
        if (this.m_tsTok != null) {
            b = this.m_tsTok.getTimeStampInfo().getSerialNumber();
        }
        return b;
    }

    public boolean isOrdered() {
        boolean b = false;
        if (this.m_tsTok != null) {
            b = this.m_tsTok.getTimeStampInfo().isOrdered();
        }
        return b;
    }

    public String getSignerCN() {
        String s = null;
        if (this.m_tsTok != null) {
            // empty if block
        }
        return s;
    }

    public ArrayList validate() {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateId(this.m_id);
        if (ex != null) {
            errs.add(ex);
        }
        if ((ex = this.validateType(this.m_type)) != null) {
            errs.add(ex);
        }
        return errs;
    }
}

