/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.ddoc.c14n;

import java.io.ByteArrayOutputStream;
import org.digidoc4j.ddoc.DigiDocException;
import org.digidoc4j.ddoc.c14n.TinyXMLCanonicalizerHandler;
import org.digidoc4j.ddoc.c14n.TinyXMLParser;
import org.digidoc4j.ddoc.factory.CanonicalizationFactory;

public class TinyXMLCanonicalizer
implements CanonicalizationFactory {
    @Override
    public void init() {
    }

    @Override
    public byte[] canonicalize(byte[] data, String uri) throws DigiDocException {
        byte[] byteArray3;
        try {
            TinyXMLParser p = new TinyXMLParser();
            TinyXMLCanonicalizerHandler h = new TinyXMLCanonicalizerHandler();
            p.Parse(h, TinyXMLCanonicalizer.NormalizeLineBreaks(data));
            byteArray3 = h.get_Bytes();
        }
        catch (Throwable exc) {
            throw new DigiDocException(0, "unknown", exc);
        }
        return byteArray3;
    }

    public static byte[] NormalizeLineBreaks(byte[] data) {
        int len = data.length;
        ByteArrayOutputStream o = new ByteArrayOutputStream(len);
        byte[] n = new byte[]{10};
        for (int i = 0; i < len; ++i) {
            byte c = data[i];
            if (c == 13) {
                boolean skip = false;
                if (i + 1 < len && (c = data[i + 1]) == 10) {
                    skip = true;
                }
                if (skip) continue;
                o.write(n, 0, 1);
                continue;
            }
            o.write(data, i, 1);
        }
        return o.toByteArray();
    }
}

