/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.ddoc.utils;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.digidoc4j.ddoc.DigiDocException;
import org.digidoc4j.ddoc.SignedDoc;
import org.digidoc4j.ddoc.factory.CanonicalizationFactory;
import org.digidoc4j.ddoc.factory.DigiDocFactory;
import org.digidoc4j.ddoc.factory.NotaryFactory;
import org.digidoc4j.ddoc.factory.SignatureFactory;
import org.digidoc4j.ddoc.factory.TrustServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static Properties m_props = null;
    private static ConfigManager m_instance = null;
    private static NotaryFactory m_notFac = null;
    private static CanonicalizationFactory m_canFac = null;
    private static Logger m_logger = LoggerFactory.getLogger(ConfigManager.class);
    private static SignatureFactory m_sigFac = null;
    private static TrustServiceFactory m_tslFac = null;

    public static ConfigManager instance() {
        if (m_instance == null) {
            m_instance = new ConfigManager();
        }
        return m_instance;
    }

    private ConfigManager() {
    }

    public void reset() {
        m_props = new Properties();
    }

    public static boolean isSignatureKey(X509Certificate cert) {
        boolean[] keyUsages;
        return cert != null && (keyUsages = cert.getKeyUsage()) != null && keyUsages.length > 2 && keyUsages[1];
    }

    public static Provider addProvider() {
        try {
            String s = ConfigManager.instance().getStringProperty("DIGIDOC_SECURITY_PROVIDER", "org.bouncycastle.jce.provider.BouncyCastleProvider");
            Provider prv = (Provider)Class.forName(ConfigManager.instance().getStringProperty("DIGIDOC_SECURITY_PROVIDER", "org.bouncycastle.jce.provider.BouncyCastleProvider")).newInstance();
            Security.addProvider(prv);
            return prv;
        }
        catch (Exception ex) {
            m_logger.error("Error adding provider: " + ex);
            return null;
        }
    }

    public static boolean init(String cfgFileName) {
        boolean bOk = false;
        try {
            if (m_props == null) {
                m_props = new Properties();
            }
            InputStream isCfg = null;
            URL url = null;
            if (cfgFileName.startsWith("http")) {
                url = new URL(cfgFileName);
                isCfg = url.openStream();
            } else if (cfgFileName.startsWith("jar://")) {
                ClassLoader cl = ConfigManager.class.getClassLoader();
                isCfg = cl.getResourceAsStream(cfgFileName.substring(6));
            } else {
                isCfg = new FileInputStream(cfgFileName);
            }
            m_props.load(isCfg);
            isCfg.close();
            url = null;
            bOk = true;
        }
        catch (Exception ex) {
            m_logger.error("Cannot read config file: " + cfgFileName + " Reason: " + ex.toString());
        }
        return bOk;
    }

    public static void init(Hashtable hProps) {
        m_props = new Properties();
        m_props.putAll((Map<?, ?>)hProps);
    }

    public TrustServiceFactory getTslFactory() throws DigiDocException {
        try {
            if (m_tslFac == null && (m_tslFac = (TrustServiceFactory)Class.forName(this.getProperty("DIGIDOC_TSLFAC_IMPL")).newInstance()) != null) {
                m_tslFac.init();
            }
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 56);
        }
        return m_tslFac;
    }

    public NotaryFactory getNotaryFactory() throws DigiDocException {
        try {
            if (m_notFac == null) {
                m_notFac = (NotaryFactory)Class.forName(this.getProperty("DIGIDOC_NOTARY_IMPL")).newInstance();
                m_notFac.init();
            }
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 67);
        }
        return m_notFac;
    }

    public DigiDocFactory getDigiDocFactory() throws DigiDocException {
        DigiDocFactory ddocFac = null;
        try {
            ddocFac = (DigiDocFactory)Class.forName(this.getProperty("DIGIDOC_FACTORY_IMPL")).newInstance();
            ddocFac.init();
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 76);
        }
        return ddocFac;
    }

    public CanonicalizationFactory getCanonicalizationFactory() throws DigiDocException {
        try {
            if (m_canFac == null) {
                m_canFac = (CanonicalizationFactory)Class.forName(this.getProperty("CANONICALIZATION_FACTORY_IMPL")).newInstance();
                m_canFac.init();
            }
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 86);
        }
        return m_canFac;
    }

    public String getProperty(String key) {
        return m_props.getProperty(key);
    }

    public String getStringProperty(String key, String def) {
        return m_props.getProperty(key, def);
    }

    public void setStringProperty(String key, String value) {
        if (m_props != null) {
            m_props.put(key, value);
        }
    }

    public int getIntProperty(String key, int def) {
        int rc = def;
        try {
            String s = m_props.getProperty(key);
            if (s != null && s.trim().length() > 0) {
                rc = Integer.parseInt(s);
            }
        }
        catch (NumberFormatException ex) {
            m_logger.error("Error parsing number: " + key, (Throwable)ex);
        }
        return rc;
    }

    public long getLongProperty(String key, long def) {
        long rc = def;
        try {
            String s = m_props.getProperty(key);
            if (s != null && s.trim().length() > 0) {
                rc = Long.parseLong(s);
            }
        }
        catch (NumberFormatException ex) {
            m_logger.error("Error parsing number: " + key, (Throwable)ex);
        }
        return rc;
    }

    public List<String> getAllowedOcspProviders() {
        String ocspResponders = this.getProperty("ALLOWED_OCSP_RESPONDERS_FOR_TM");
        return new ArrayList<String>(Arrays.asList(ocspResponders.split(",")));
    }

    public boolean getBooleanProperty(String key, boolean def) {
        boolean rc = def;
        try {
            String s = m_props.getProperty(key);
            if (s != null) {
                if (s.trim().equalsIgnoreCase("TRUE")) {
                    rc = true;
                }
                if (s.trim().equalsIgnoreCase("FALSE")) {
                    rc = false;
                }
            }
        }
        catch (NumberFormatException ex) {
            m_logger.error("Error parsing boolean: " + key, (Throwable)ex);
        }
        return rc;
    }

    public String getDefaultDigestType(SignedDoc sdoc) {
        return "SHA-1";
    }

    public static String digType2Alg(String digType) {
        if (digType != null && digType.equals("SHA-1")) {
            return "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        return null;
    }

    public static String sigMeth2SigType(String sigMeth, boolean bCvc) {
        if (sigMeth != null) {
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1")) {
                return bCvc ? "SHA1withCVC-ECDSA" : "SHA1withECDSA";
            }
            if (sigMeth.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                return "SHA1withRSA";
            }
        }
        return null;
    }

    public static String digAlg2Type(String digAlg) {
        if (digAlg != null && digAlg.equals("http://www.w3.org/2000/09/xmldsig#sha1")) {
            return "SHA-1";
        }
        return null;
    }

    public static String sigMeth2Type(String sigMeth) {
        if (sigMeth != null) {
            if (sigMeth.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                return "SHA-1";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1")) {
                return "SHA-1";
            }
        }
        return null;
    }
}

