/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.asice;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESCommonParameters;
import eu.europa.esig.dss.asic.cades.signature.manifest.ASiCEWithCAdESManifestBuilder;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractDataToSignASiCEWithCAdES {
    private static final String ASIC_MANIFEST_NAME = "ASiCManifest";
    private static final String ZIP_ENTRY_ASICE_METAINF_CADES_SIGNATURE = "META-INF/signature001.p7s";
    private static final String ZIP_ENTRY_ASICE_METAINF_TIMESTAMP = "META-INF/timestamp001.tst";

    protected DSSDocument getASiCManifest(SigningOperation operation, List<DSSDocument> documents, List<DSSDocument> signatures, List<DSSDocument> timestamps, List<DSSDocument> manifests, ASiCWithCAdESCommonParameters parameters) {
        String uri = null;
        uri = SigningOperation.SIGN == operation ? this.getSignatureFileName(parameters.aSiC(), signatures) : this.getTimestampFileName(timestamps);
        ASiCEWithCAdESManifestBuilder manifestBuilder = new ASiCEWithCAdESManifestBuilder(operation, documents, parameters.getDigestAlgorithm(), uri);
        String newManifestName = ASiCUtils.getNextASiCEManifestName((String)ASIC_MANIFEST_NAME, manifests);
        return DomUtils.createDssDocumentFromDomDocument((Document)manifestBuilder.build(), (String)newManifestName);
    }

    protected String getSignatureFileName(ASiCParameters asicParameters, List<DSSDocument> existingSignatures) {
        if (Utils.isStringNotBlank((String)asicParameters.getSignatureFileName())) {
            return "META-INF/" + asicParameters.getSignatureFileName();
        }
        int num = Utils.collectionSize(existingSignatures) + 1;
        return ZIP_ENTRY_ASICE_METAINF_CADES_SIGNATURE.replace("001", ASiCUtils.getPadNumber((int)num));
    }

    protected String getTimestampFileName(List<DSSDocument> existingTimestamps) {
        int num = Utils.collectionSize(existingTimestamps) + 1;
        return ZIP_ENTRY_ASICE_METAINF_TIMESTAMP.replace("001", ASiCUtils.getPadNumber((int)num));
    }
}

