/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.asics;

import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asics.AbstractGetDataToSignASiCSWithCAdES;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DataToSignASiCSWithCAdESFromFiles
extends AbstractGetDataToSignASiCSWithCAdES
implements GetDataToSignASiCWithCAdESHelper {
    private final List<DSSDocument> filesToBeSigned;
    private final Date signingDate;
    private final ASiCParameters asicParameters;
    private List<DSSDocument> signedDocuments;

    public DataToSignASiCSWithCAdESFromFiles(List<DSSDocument> filesToBeSigned, Date signingDate, ASiCParameters asicParameters) {
        this.filesToBeSigned = filesToBeSigned;
        this.signingDate = signingDate;
        this.asicParameters = asicParameters;
    }

    public String getSignatureFilename() {
        return this.getSignatureFileName(this.asicParameters);
    }

    public String getTimestampFilename() {
        return this.getTimestampFileName();
    }

    @Override
    public DSSDocument getToBeSigned() {
        return this.getSignedDocuments().get(0);
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        return Collections.emptyList();
    }

    public List<DSSDocument> getSignedDocuments() {
        if (this.signedDocuments == null) {
            this.signedDocuments = Utils.collectionSize(this.filesToBeSigned) > 1 ? Arrays.asList(this.createPackageZip(this.filesToBeSigned, this.signingDate)) : new ArrayList<DSSDocument>(this.filesToBeSigned);
        }
        return this.signedDocuments;
    }

    public List<DSSDocument> getManifestFiles() {
        return Collections.emptyList();
    }

    public List<DSSDocument> getSignatures() {
        return new ArrayList<DSSDocument>();
    }

    @Override
    public List<DSSDocument> getArchiveManifestFiles() {
        return Collections.emptyList();
    }

    @Override
    public List<DSSDocument> getTimestamps() {
        return new ArrayList<DSSDocument>();
    }
}

