/**
 * DSS - Digital Signature Services
 * Copyright (C) 2015 European Commission, provided under the CEF programme
 * 
 * This file is part of the "DSS - Digital Signature Services" project.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package eu.europa.esig.dss.asic.cades.signature.manifest;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;

/**
 * This class is used to create a Manifest file for a signature creation
 *
 */
public class ASiCWithCAdESSignatureManifestBuilder extends ASiCEWithCAdESManifestBuilder {

    /**
     * The default constructor
     *
     * @param asicContent     {@link ASiCContent} representing container's document structure
     * @param digestAlgorithm {@link DigestAlgorithm} to use for reference digest computation
     * @param documentUri     {@link String} filename of the document associated with the manifest
     */
    public ASiCWithCAdESSignatureManifestBuilder(ASiCContent asicContent, DigestAlgorithm digestAlgorithm, String documentUri) {
        super(asicContent, digestAlgorithm, documentUri);
    }

    /**
     * Constructor with filename factory
     *
     * @param asicContent {@link ASiCContent} representing container's document structure
     * @param digestAlgorithm {@link DigestAlgorithm} to use for reference digest computation
     * @param documentUri {@link String} filename of the document associated with the manifest
     * @param asicFilenameFactory {@link ASiCWithCAdESFilenameFactory}
     */
    public ASiCWithCAdESSignatureManifestBuilder(final ASiCContent asicContent, final DigestAlgorithm digestAlgorithm,
                                            final String documentUri, final ASiCWithCAdESFilenameFactory asicFilenameFactory) {
        super(asicContent, digestAlgorithm, documentUri, asicFilenameFactory);
    }

    @Override
    protected MimeType getSigReferenceMimeType() {
        return MimeTypeEnum.PKCS7;
    }

}
